/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.artifact.DefaultNId;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNIdBuilder
implements NIdBuilder {
    private String groupId;
    private String artifactId;
    private String classifier;
    private NVersion version;
    private NEnvConditionBuilder condition = new DefaultNEnvConditionBuilder();
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public DefaultNIdBuilder() {
        this.condition = new DefaultNEnvConditionBuilder();
    }

    public DefaultNIdBuilder(NId id) {
        this.copyFrom(id);
    }

    public DefaultNIdBuilder(NIdBuilder id) {
        this.copyFrom(id);
    }

    public DefaultNIdBuilder(String groupId, String artifactId) {
        this.groupId = NStringUtils.trimToNull(groupId);
        this.artifactId = NStringUtils.trimToNull(artifactId);
    }

    public DefaultNIdBuilder(String groupId, String artifactId, NVersion version, String classifier, String propertiesQuery, NEnvCondition condition) {
        this.groupId = NStringUtils.trimToNull(groupId);
        this.artifactId = NStringUtils.trimToNull(artifactId);
        this.classifier = NStringUtils.trimToNull(classifier);
        this.version = version == null ? NVersion.BLANK : version;
        this.setCondition(condition);
        this.setProperties(this.properties);
    }

    @Override
    public NIdBuilder copyFrom(NId id) {
        if (id == null) {
            this.clear();
        } else {
            this.setCondition(id.getCondition());
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setClassifier(id.getClassifier());
            this.setCondition(id.getCondition());
            this.setPropertiesQuery(id.getPropertiesQuery());
        }
        return this;
    }

    @Override
    public NIdBuilder clear() {
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion((NVersion)null);
        this.setPropertiesQuery("");
        return this;
    }

    @Override
    public NIdBuilder copyFrom(NIdBuilder id) {
        if (id == null) {
            this.clear();
        } else {
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setPropertiesQuery(id.getPropertiesQuery());
        }
        return this;
    }

    @Override
    public NIdBuilder setGroupId(String value) {
        this.groupId = NStringUtils.trimToNull(value);
        return this;
    }

    @Override
    public NIdBuilder setRepository(String value) {
        return this.setProperty("repo", NStringUtils.trimToNull(value));
    }

    @Override
    public NIdBuilder setVersion(NVersion value) {
        this.version = value == null ? NVersion.BLANK : value;
        return this;
    }

    @Override
    public NIdBuilder setVersion(String value) {
        this.version = NVersion.get(value).get();
        return this;
    }

    @Override
    public DefaultNIdBuilder setArtifactId(String value) {
        this.artifactId = NStringUtils.trimToNull(value);
        return this;
    }

    @Override
    public String getFace() {
        String s = this.getProperties().get("face");
        return NStringUtils.trimToNull(s);
    }

    @Override
    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NStringUtils.trimToNull(s);
    }

    @Override
    public NIdBuilder setFace(String value) {
        return this.setProperty("face", NStringUtils.trimToNull(value));
    }

    @Override
    public NIdBuilder setFaceContent() {
        return this.setFace("content");
    }

    @Override
    public NIdBuilder setFaceDescriptor() {
        return this.setFace("descriptor");
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public NIdBuilder setClassifier(String value) {
        this.classifier = NStringUtils.trimToNull(value);
        return this;
    }

    @Override
    public NIdBuilder setPackaging(String value) {
        return this.setProperty("packaging", NStringUtils.trimToNull(value));
    }

    @Override
    public NIdBuilder setCondition(NEnvCondition c) {
        if (c == null) {
            this.setProperty("os", null);
            this.setProperty("osdist", null);
            this.setProperty("arch", null);
            this.setProperty("platform", null);
            this.setProperty("desktop", null);
            this.setProperty("profile", null);
            this.condition.setProperties(null);
        } else {
            this.setProperty("os", NReservedLangUtils.joinAndTrimToNull(c.getOs()));
            this.setProperty("osdist", NReservedLangUtils.joinAndTrimToNull(c.getOsDist()));
            this.setProperty("arch", NReservedLangUtils.joinAndTrimToNull(c.getArch()));
            this.setProperty("platform", NReservedUtils.formatStringIdList(c.getPlatform()));
            this.setProperty("desktop", NReservedLangUtils.joinAndTrimToNull(c.getDesktopEnvironment()));
            this.setProperty("profile", NReservedLangUtils.joinAndTrimToNull(c.getProfiles()));
            this.condition.setProperties(c.getProperties());
        }
        return this;
    }

    @Override
    public NEnvConditionBuilder getCondition() {
        return this.condition;
    }

    @Override
    public NIdBuilder setCondition(NEnvConditionBuilder c) {
        if (c == null) {
            return this.setCondition((NEnvCondition)null);
        }
        return this.setCondition(c.build());
    }

    @Override
    public NIdBuilder setProperty(String property, String value) {
        switch (property) {
            case "os": {
                this.condition.setOs(NStringUtils.parsePropertyIdList(value).get());
                break;
            }
            case "osdist": {
                this.condition.setOsDist(NStringUtils.parsePropertyIdList(value).get());
                break;
            }
            case "arch": {
                this.condition.setArch(NStringUtils.parsePropertyIdList(value).get());
                break;
            }
            case "platform": {
                this.condition.setPlatform(NStringUtils.parsePropertyIdList(value).get());
                break;
            }
            case "desktop": {
                this.condition.setDesktopEnvironment(NStringUtils.parsePropertyIdList(value).get());
                break;
            }
            case "profile": {
                this.condition.setProfile(NStringUtils.parsePropertyIdList(value).get());
                break;
            }
            case "cond-properties": {
                this.condition.setProperties(NStringMapFormat.COMMA_FORMAT.parse(value).get());
                break;
            }
            case "classifier": {
                this.setClassifier(value);
                break;
            }
            case "version": {
                this.setVersion(value);
                break;
            }
            default: {
                if (value == null) {
                    this.properties.remove(property);
                    break;
                }
                this.properties.put(property, value);
            }
        }
        return this;
    }

    @Override
    public NIdBuilder setProperties(Map<String, String> queryMap) {
        for (Map.Entry<String, String> e : queryMap.entrySet()) {
            this.setProperty(e.getKey(), e.getValue());
        }
        return this;
    }

    @Override
    public NIdBuilder clearProperties() {
        this.properties.clear();
        return this;
    }

    @Override
    public NIdBuilder setPropertiesQuery(String propertiesQuery) {
        this.setProperties(NStringMapFormat.DEFAULT.parse(propertiesQuery).get());
        return this;
    }

    @Override
    public String getPropertiesQuery() {
        return NStringMapFormat.DEFAULT.format(this.getProperties());
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getRepository() {
        return NStringUtils.trimToNull(this.getProperties().get("repo"));
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getFullName() {
        return this.build().getFullName();
    }

    @Override
    public String getShortName() {
        return NReservedUtils.getIdShortName(this.groupId, this.artifactId, this.classifier);
    }

    @Override
    public String getLongName() {
        return NReservedUtils.getIdLongName(this.groupId, this.artifactId, this.version, this.classifier);
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public NVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return this.build().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNIdBuilder nutsId = (DefaultNIdBuilder)o;
        if (!Objects.equals(this.groupId, nutsId.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, nutsId.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, nutsId.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, nutsId.classifier)) {
            return false;
        }
        return Objects.equals(this.properties, nutsId.properties);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    @Override
    public NId build() {
        return new DefaultNId(this.groupId, this.artifactId, this.classifier, this.version, this.properties, this.condition.build());
    }

    @Override
    public boolean equalsShortId(NId other) {
        if (other == null) {
            return false;
        }
        return NStringUtils.trim(this.groupId).equals(NStringUtils.trim(other.getArtifactId())) && NStringUtils.trim(this.artifactId).equals(NStringUtils.trim(other.getGroupId()));
    }

    @Override
    public boolean equalsLongId(NId other) {
        if (other == null) {
            return false;
        }
        return NStringUtils.trim(this.artifactId).equals(NStringUtils.trim(other.getArtifactId())) && NStringUtils.trim(this.groupId).equals(NStringUtils.trim(other.getGroupId())) && Objects.equals(this.version == null || this.version.isBlank() ? null : this.version, other.getVersion() == null || other.getVersion().isBlank() ? null : other.getVersion()) && Objects.equals(this.getClassifier(), other.getClassifier());
    }

    @Override
    public boolean isLongId() {
        return this.build().isLongId();
    }

    @Override
    public boolean isShortId() {
        return this.build().isShortId();
    }

    @Override
    public NId getShortId() {
        return this.build().getShortId();
    }

    @Override
    public NId getLongId() {
        return this.build().getLongId();
    }

    @Override
    public NIdBuilder builder() {
        return new DefaultNIdBuilder(this);
    }

    @Override
    public NDependency toDependency() {
        return this.build().toDependency();
    }

    @Override
    public NIdFilter filter() {
        return this.build().filter();
    }

    @Override
    public NId compatNewer() {
        return this.build().compatNewer();
    }

    @Override
    public NId compatOlder() {
        return this.build().compatOlder();
    }

    @Override
    public boolean isNull() {
        return this.build().isNull();
    }

    @Override
    public boolean isBlank() {
        return this.build().isBlank();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

