/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.DefaultNEnvCondition;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.boot.NBootEnvCondition;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNEnvConditionBuilder
implements Serializable,
NEnvConditionBuilder {
    private static final long serialVersionUID = 1L;
    private List<String> arch = new ArrayList<String>();
    private List<String> os = new ArrayList<String>();
    private List<String> osDist = new ArrayList<String>();
    private List<String> platform = new ArrayList<String>();
    private List<String> desktopEnvironment = new ArrayList<String>();
    private List<String> profiles = new ArrayList<String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public DefaultNEnvConditionBuilder() {
    }

    public DefaultNEnvConditionBuilder(NEnvCondition other) {
        this.copyFrom(other);
    }

    public DefaultNEnvConditionBuilder(NEnvConditionBuilder other) {
        this.copyFrom(other);
    }

    @Override
    public List<String> getArch() {
        return this.arch;
    }

    @Override
    public NEnvConditionBuilder setArch(List<String> arch) {
        this.arch = NReservedLangUtils.uniqueNonBlankList(arch);
        return this;
    }

    @Override
    public List<String> getOs() {
        return this.os;
    }

    @Override
    public NEnvConditionBuilder setOs(List<String> os) {
        this.os = NReservedLangUtils.uniqueNonBlankList(os);
        return this;
    }

    @Override
    public List<String> getOsDist() {
        return this.osDist;
    }

    @Override
    public NEnvConditionBuilder setOsDist(List<String> osDist) {
        this.osDist = NReservedLangUtils.uniqueNonBlankList(osDist);
        return this;
    }

    @Override
    public List<String> getPlatform() {
        return this.platform;
    }

    @Override
    public NEnvConditionBuilder setPlatform(List<String> platform) {
        this.platform = NReservedLangUtils.uniqueNonBlankList(platform);
        return this;
    }

    @Override
    public List<String> getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    @Override
    public NEnvConditionBuilder setDesktopEnvironment(List<String> desktopEnvironment) {
        this.desktopEnvironment = NReservedLangUtils.uniqueNonBlankList(desktopEnvironment);
        return this;
    }

    @Override
    public List<String> getProfiles() {
        return this.profiles;
    }

    @Override
    public NEnvConditionBuilder setProfile(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    @Override
    public NEnvConditionBuilder copyFrom(NEnvCondition other) {
        if (other != null) {
            this.setArch(this.mergeLists(this.getArch(), other.getArch()));
            this.setOs(this.mergeLists(this.getOs(), other.getOs()));
            this.setOsDist(this.mergeLists(this.getOsDist(), other.getOsDist()));
            this.setPlatform(this.mergeLists(this.getPlatform(), other.getPlatform()));
            this.setDesktopEnvironment(this.mergeLists(this.getDesktopEnvironment(), other.getDesktopEnvironment()));
            this.setProfile(this.mergeLists(this.getProfiles(), other.getProfiles()));
            this.setProperties(this.mergeMaps(this.getProperties(), other.getProperties()));
        }
        return this;
    }

    @Override
    public NEnvConditionBuilder copyFrom(NEnvConditionBuilder other) {
        if (other != null) {
            this.setArch(this.mergeLists(this.getArch(), other.getArch()));
            this.setOs(this.mergeLists(this.getOs(), other.getOs()));
            this.setOsDist(this.mergeLists(this.getOsDist(), other.getOsDist()));
            this.setPlatform(this.mergeLists(this.getPlatform(), other.getPlatform()));
            this.setDesktopEnvironment(this.mergeLists(this.getDesktopEnvironment(), other.getDesktopEnvironment()));
            this.setProfile(this.mergeLists(this.getProfiles(), other.getProfiles()));
            this.setProperties(this.mergeMaps(this.getProperties(), other.getProperties()));
        }
        return this;
    }

    public NEnvConditionBuilder copyFrom(NBootEnvCondition other) {
        if (other != null) {
            this.setArch(this.mergeLists(this.getArch(), other.getArch()));
            this.setOs(this.mergeLists(this.getOs(), other.getOs()));
            this.setOsDist(this.mergeLists(this.getOsDist(), other.getOsDist()));
            this.setPlatform(this.mergeLists(this.getPlatform(), other.getPlatform()));
            this.setDesktopEnvironment(this.mergeLists(this.getDesktopEnvironment(), other.getDesktopEnvironment()));
            this.setProfile(this.mergeLists(this.getProfiles(), other.getProfiles()));
            this.setProperties(this.mergeMaps(this.getProperties(), other.getProperties()));
        }
        return this;
    }

    private Map<String, String> mergeMaps(Map<String, String> a, Map<String, String> b) {
        LinkedHashMap<String, String> n = new LinkedHashMap<String, String>();
        if (a != null) {
            n.putAll(a);
        }
        if (a != null) {
            n.putAll(b);
        }
        return n;
    }

    private List<String> mergeLists(List<String> a, List<String> b) {
        LinkedHashSet<String> n = new LinkedHashSet<String>();
        if (a != null) {
            n.addAll(a);
        }
        if (a != null) {
            n.addAll(b);
        }
        return new ArrayList<String>(n);
    }

    @Override
    public NEnvConditionBuilder clear() {
        this.setArch(new ArrayList<String>());
        this.setOs(new ArrayList<String>());
        this.setOsDist(new ArrayList<String>());
        this.setPlatform(new ArrayList<String>());
        this.setDesktopEnvironment(new ArrayList<String>());
        this.setProfile(new ArrayList<String>());
        this.setProperties(new LinkedHashMap<String, String>());
        return this;
    }

    @Override
    public NEnvConditionBuilder copy() {
        return new DefaultNEnvConditionBuilder(this);
    }

    @Override
    public NEnvCondition build() {
        return new DefaultNEnvCondition(this.getArch(), this.getOs(), this.getOsDist(), this.getPlatform(), this.getDesktopEnvironment(), this.getProfiles(), this.properties);
    }

    public String toString() {
        String s = String.join((CharSequence)" & ", (CharSequence[])Arrays.stream(new String[]{this.ts("arch", this.arch.toArray(new String[0])), this.ts("os", this.os.toArray(new String[0])), this.ts("osDist", this.osDist.toArray(new String[0])), this.ts("platform", this.platform.toArray(new String[0])), this.ts("desktop", this.desktopEnvironment.toArray(new String[0])), this.ts("profile", this.profiles.toArray(new String[0])), this.ts("props", this.properties)}).filter(x -> x.length() > 0).toArray(String[]::new));
        if (s.isEmpty()) {
            return "blank";
        }
        return s;
    }

    private String ts(String n, String[] vs) {
        if (vs.length == 0) {
            return "";
        }
        return n + "=" + String.join((CharSequence)",", vs[0]);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public NEnvConditionBuilder setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new HashMap<String, String>(properties);
        return this;
    }

    @Override
    public NEnvConditionBuilder addProperties(Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                this.addProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    @Override
    public NEnvConditionBuilder addProperty(String key, String value) {
        if ((key = NStringUtils.trimToNull(key)) != null) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
        }
        return this;
    }

    @Override
    public NEnvConditionBuilder addDesktopEnvironment(String value) {
        this.desktopEnvironment = NReservedLangUtils.addUniqueNonBlankList(this.desktopEnvironment, value);
        return this;
    }

    @Override
    public NEnvConditionBuilder addDesktopEnvironments(String ... values) {
        this.desktopEnvironment = NReservedLangUtils.addUniqueNonBlankList(this.desktopEnvironment, values);
        return this;
    }

    @Override
    public NEnvConditionBuilder addArchs(String value) {
        this.arch = NReservedLangUtils.addUniqueNonBlankList(this.arch, value);
        return this;
    }

    @Override
    public NEnvConditionBuilder addArchs(String ... values) {
        this.arch = NReservedLangUtils.addUniqueNonBlankList(this.arch, values);
        return this;
    }

    @Override
    public NEnvConditionBuilder addOs(String value) {
        this.os = NReservedLangUtils.addUniqueNonBlankList(this.os, value);
        return this;
    }

    @Override
    public NEnvConditionBuilder addOses(String ... values) {
        this.os = NReservedLangUtils.addUniqueNonBlankList(this.os, values);
        return this;
    }

    @Override
    public NEnvConditionBuilder addOsDist(String value) {
        this.osDist = NReservedLangUtils.addUniqueNonBlankList(this.osDist, value);
        return this;
    }

    @Override
    public NEnvConditionBuilder addOsDists(String ... values) {
        this.osDist = NReservedLangUtils.addUniqueNonBlankList(this.osDist, values);
        return this;
    }

    @Override
    public NEnvConditionBuilder addPlatform(String value) {
        this.platform = NReservedLangUtils.addUniqueNonBlankList(this.platform, value);
        return this;
    }

    @Override
    public NEnvConditionBuilder addPlatforms(String ... values) {
        this.platform = NReservedLangUtils.addUniqueNonBlankList(this.platform, values);
        return this;
    }

    @Override
    public NEnvConditionBuilder addProfile(String value) {
        this.profiles = NReservedLangUtils.addUniqueNonBlankList(this.profiles, value);
        return this;
    }

    @Override
    public NEnvConditionBuilder addProfiles(String ... values) {
        this.profiles = NReservedLangUtils.addUniqueNonBlankList(this.profiles, values);
        return this;
    }

    @Override
    public NEnvConditionBuilder and(NEnvCondition other) {
        if (other != null) {
            ArrayList<String> c_arch = new ArrayList<String>(this.arch);
            ArrayList<String> c_os = new ArrayList<String>(this.os);
            ArrayList<String> c_osDist = new ArrayList<String>(this.osDist);
            ArrayList<String> c_platform = new ArrayList<String>(this.platform);
            ArrayList<String> c_desktopEnvironment = new ArrayList<String>(this.desktopEnvironment);
            ArrayList<String> c_profiles = new ArrayList<String>(this.profiles);
            HashMap<String, String> c_properties = new HashMap<String, String>(this.properties);
            ArrayList<String> o_arch = new ArrayList<String>(other.getArch());
            ArrayList<String> o_os = new ArrayList<String>(other.getOs());
            ArrayList<String> o_osDist = new ArrayList<String>(other.getOsDist());
            ArrayList<String> o_platform = new ArrayList<String>(other.getPlatform());
            ArrayList<String> o_desktopEnvironment = new ArrayList<String>(other.getDesktopEnvironment());
            ArrayList<String> o_profiles = new ArrayList<String>(other.getProfiles());
            HashMap<String, String> o_properties = new HashMap<String, String>(other.getProperties());
            this.arch.clear();
            this.arch.addAll(this.intersectIds("arch", c_arch, o_arch));
            this.os.clear();
            this.os.addAll(this.intersectIds("os", c_os, o_os));
            this.osDist.clear();
            this.osDist.addAll(this.intersectIds("osDist", c_osDist, o_osDist));
            this.platform.clear();
            this.platform.addAll(this.intersectIds("platform", c_platform, o_platform));
            this.desktopEnvironment.clear();
            this.desktopEnvironment.addAll(this.intersectIds("desktopEnvironment", c_desktopEnvironment, o_desktopEnvironment));
            this.profiles.clear();
            this.profiles.addAll(this.intersect("profiles", c_profiles, o_profiles));
            this.properties.clear();
            this.properties.putAll(this.intersect("properties", c_properties, o_properties));
        }
        return this;
    }

    private List<String> intersectIds(String name, List<String> a, List<String> b) {
        if (a.isEmpty()) {
            return new ArrayList<String>(b);
        }
        if (b.isEmpty()) {
            return new ArrayList<String>(a);
        }
        LinkedHashMap<String, NId> am = new LinkedHashMap<String, NId>();
        for (String string : a) {
            if (NBlankable.isBlank(string)) continue;
            NId nv = NId.of(string);
            am.put(nv.getShortName(), nv);
        }
        LinkedHashMap<String, NId> bm = new LinkedHashMap<String, NId>();
        for (String s : a) {
            if (NBlankable.isBlank(s)) continue;
            NId nv = NId.of(s);
            bm.put(nv.getShortName(), nv);
        }
        if (am.isEmpty()) {
            return b;
        }
        if (bm.isEmpty()) {
            return a;
        }
        HashSet hashSet = new HashSet();
        LinkedHashMap<String, String> allKeyMap = new LinkedHashMap<String, String>();
        hashSet.addAll(am.keySet());
        hashSet.addAll(bm.keySet());
        for (String s : new LinkedHashSet(hashSet)) {
            if (!am.containsKey(s) || !bm.containsKey(s)) continue;
            NId aa = (NId)am.get(s);
            NId bb = (NId)bm.get(s);
            if (aa.toString().length() > bb.toString().length()) {
                allKeyMap.put(aa.toString(), bb.toString());
                continue;
            }
            allKeyMap.put(aa.toString(), aa.toString());
        }
        if (allKeyMap.isEmpty()) {
            throw new IllegalArgumentException("invalid " + name + " as intersection of " + a + " and " + b);
        }
        return new ArrayList<String>(allKeyMap.values());
    }

    private List<String> intersect(String name, List<String> a, List<String> b) {
        if (a.isEmpty()) {
            return new ArrayList<String>(b);
        }
        if (b.isEmpty()) {
            return new ArrayList<String>(a);
        }
        ArrayList<String> s = new ArrayList<String>(a);
        s.retainAll(b);
        if (s.isEmpty()) {
            throw new IllegalArgumentException("invalid " + name + " as intersection of " + a + " and " + b);
        }
        return s;
    }

    private Map<String, String> intersect(String name, Map<String, String> a, Map<String, String> b) {
        if (a.isEmpty()) {
            return new LinkedHashMap<String, String>(b);
        }
        if (b.isEmpty()) {
            return new LinkedHashMap<String, String>(a);
        }
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>(b);
        for (Map.Entry<String, String> e : b.entrySet()) {
            String k = e.getKey();
            String v1 = s.get(k);
            String v2 = e.getValue();
            if (NBlankable.isBlank(v1)) {
                s.put(k, v2);
                continue;
            }
            if (Objects.equals(v1, v2)) continue;
            throw new IllegalArgumentException("invalid " + name + " as intersection of " + v1 + " and " + v2 + " for key " + k);
        }
        return s;
    }

    private List<String> union(List<String> a, List<String> b) {
        if (a.isEmpty()) {
            return new ArrayList<String>(b);
        }
        if (b.isEmpty()) {
            return new ArrayList<String>(a);
        }
        ArrayList<String> s = new ArrayList<String>(b);
        s.addAll(b);
        return new ArrayList<String>(new LinkedHashSet<String>(s));
    }

    @Override
    public NEnvConditionBuilder or(NEnvCondition other) {
        return null;
    }

    private String ts(String n, Map<String, String> properties) {
        if (properties.isEmpty()) {
            return "";
        }
        return n + "={" + properties.entrySet().stream().map(x -> {
            String k = (String)x.getKey();
            String v = (String)x.getValue();
            if (v == null) {
                return k;
            }
            return k + "=" + v;
        }).collect(Collectors.joining(",")) + "}";
    }

    @Override
    public boolean isBlank() {
        if (this.arch != null && !this.arch.isEmpty()) {
            return false;
        }
        if (this.os != null && !this.os.isEmpty()) {
            return false;
        }
        if (this.osDist != null && !this.osDist.isEmpty()) {
            return false;
        }
        if (this.platform != null && !this.platform.isEmpty()) {
            return false;
        }
        if (this.desktopEnvironment != null && !this.desktopEnvironment.isEmpty()) {
            return false;
        }
        if (this.profiles != null && !this.profiles.isEmpty()) {
            return false;
        }
        return this.properties == null || this.properties.isEmpty();
    }

    @Override
    public Map<String, String> toMap() {
        return NReservedUtils.toMap(this.build());
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

