/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NDescriptorContributor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NDescriptorLicense;
import net.thevpc.nuts.artifact.NDescriptorMailingList;
import net.thevpc.nuts.artifact.NDescriptorOrganization;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdLocation;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.util.DefaultNProperties;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDescriptor
implements NDescriptor {
    private static final long serialVersionUID = 1L;
    private final String solver;
    private final NArtifactCall executor;
    private final NArtifactCall installer;
    private final NEnvCondition condition;
    private final List<NIdLocation> locations;
    private final List<NDependency> dependencies;
    private final List<NDependency> standardDependencies;
    private final List<NDescriptorProperty> properties;
    private final Set<NDescriptorFlag> flags;
    private NId id;
    private NIdType idType;
    private List<NId> parents;
    private String packaging;
    private String name;
    private String description;
    private List<String> icons;
    private List<String> categories;
    private String genericName;
    private List<NDescriptorContributor> contributors;
    private List<NDescriptorContributor> developers;
    private List<NDescriptorLicense> licenses;
    private List<NDescriptorMailingList> mailingLists;
    private NDescriptorOrganization organization;

    public DefaultNDescriptor(NDescriptor d) {
        this(d.getId(), d.getIdType(), d.getParents(), d.getPackaging(), d.getExecutor(), d.getInstaller(), d.getName(), d.getDescription(), d.getCondition(), d.getDependencies(), d.getStandardDependencies(), d.getLocations(), d.getProperties(), d.getGenericName(), d.getCategories(), d.getIcons(), d.getFlags(), d.getSolver(), d.getContributors(), d.getDevelopers(), d.getLicenses(), d.getMailingLists(), d.getOrganization());
    }

    public DefaultNDescriptor(NId id, NIdType idType, List<NId> parents, String packaging, NArtifactCall executor, NArtifactCall installer, String name, String description, NEnvCondition condition, List<NDependency> dependencies, List<NDependency> standardDependencies, List<NIdLocation> locations, List<NDescriptorProperty> properties, String genericName, List<String> categories, List<String> icons, Set<NDescriptorFlag> flags, String solver, List<NDescriptorContributor> contributors, List<NDescriptorContributor> developers, List<NDescriptorLicense> licenses, List<NDescriptorMailingList> mailingLists, NDescriptorOrganization organization) {
        this.id = id;
        this.idType = idType == null ? NIdType.REGULAR : idType;
        this.packaging = NStringUtils.trimToNull(packaging);
        this.parents = NReservedLangUtils.uniqueList(parents);
        this.description = NStringUtils.trimToNull(description);
        this.name = NStringUtils.trimToNull(name);
        this.genericName = NStringUtils.trimToNull(genericName);
        this.icons = NReservedLangUtils.uniqueNonBlankList(icons);
        this.categories = NReservedLangUtils.uniqueNonBlankList(categories);
        this.executor = executor;
        this.installer = installer;
        this.condition = condition == null ? NEnvCondition.BLANK : condition;
        this.locations = NReservedLangUtils.uniqueNonBlankList(locations);
        this.dependencies = NReservedLangUtils.uniqueNonBlankList(dependencies);
        this.standardDependencies = NReservedLangUtils.uniqueNonBlankList(standardDependencies);
        if (properties == null || properties.size() == 0) {
            this.properties = null;
        } else {
            DefaultNProperties p = new DefaultNProperties();
            p.addAll(properties);
            this.properties = p.toList();
        }
        this.flags = NReservedLangUtils.nonBlankSet(flags);
        this.solver = NStringUtils.trimToNull(solver);
        this.contributors = NReservedLangUtils.unmodifiableUniqueList(contributors);
        this.developers = NReservedLangUtils.unmodifiableUniqueList(developers);
        this.licenses = NReservedLangUtils.unmodifiableUniqueList(licenses);
        this.mailingLists = NReservedLangUtils.unmodifiableUniqueList(mailingLists);
        this.organization = organization;
    }

    @Override
    public NIdType getIdType() {
        return this.idType;
    }

    @Override
    public boolean isBlank() {
        if (!NBlankable.isBlank(this.id)) {
            return false;
        }
        if (!NBlankable.isBlank(this.packaging)) {
            return false;
        }
        if (this.idType != NIdType.REGULAR) {
            return false;
        }
        if (this.parents != null) {
            for (NId nId : this.parents) {
                if (NBlankable.isBlank(nId)) continue;
                return false;
            }
        }
        if (!NBlankable.isBlank(this.description)) {
            return false;
        }
        if (!NBlankable.isBlank(this.name)) {
            return false;
        }
        if (!NBlankable.isBlank(this.genericName)) {
            return false;
        }
        if (this.icons != null) {
            for (String string : this.icons) {
                if (NBlankable.isBlank(string)) continue;
                return false;
            }
        }
        if (this.developers != null) {
            for (NDescriptorContributor nDescriptorContributor : this.developers) {
                if (NBlankable.isBlank(nDescriptorContributor)) continue;
                return false;
            }
        }
        if (this.contributors != null) {
            for (NDescriptorContributor nDescriptorContributor : this.contributors) {
                if (NBlankable.isBlank(nDescriptorContributor)) continue;
                return false;
            }
        }
        if (this.licenses != null) {
            for (NDescriptorLicense nDescriptorLicense : this.licenses) {
                if (NBlankable.isBlank(nDescriptorLicense)) continue;
                return false;
            }
        }
        if (this.categories != null) {
            for (String string : this.categories) {
                if (NBlankable.isBlank(string)) continue;
                return false;
            }
        }
        if (!NBlankable.isBlank(this.executor)) {
            return false;
        }
        if (!NBlankable.isBlank(this.installer)) {
            return false;
        }
        if (!NBlankable.isBlank(this.condition)) {
            return false;
        }
        for (NIdLocation nIdLocation : this.locations) {
            if (NBlankable.isBlank(nIdLocation)) continue;
            return false;
        }
        if (this.dependencies != null) {
            for (NDependency nDependency : this.dependencies) {
                if (NBlankable.isBlank(nDependency)) continue;
                return false;
            }
        }
        if (this.standardDependencies != null) {
            for (NDependency nDependency : this.standardDependencies) {
                if (NBlankable.isBlank(nDependency)) continue;
                return false;
            }
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (NDescriptorProperty nDescriptorProperty : this.properties) {
                if (NBlankable.isBlank(nDescriptorProperty)) continue;
                return false;
            }
        }
        if (!this.flags.isEmpty()) {
            return false;
        }
        return NBlankable.isBlank(this.solver);
    }

    public boolean isValid() {
        if (NBlankable.isBlank(this.id)) {
            return false;
        }
        if (NBlankable.isBlank(this.id.getGroupId())) {
            return false;
        }
        if (NBlankable.isBlank(this.id.getArtifactId())) {
            return false;
        }
        if (NBlankable.isBlank(this.id.getVersion())) {
            return false;
        }
        return this.id.isLongId();
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public List<NId> getParents() {
        return this.parents;
    }

    @Override
    public boolean isExecutable() {
        return this.getFlags().contains(NDescriptorFlag.EXEC);
    }

    @Override
    public boolean isNutsApplication() {
        return this.getFlags().contains(NDescriptorFlag.NUTS_APP);
    }

    @Override
    public boolean isPlatformApplication() {
        return this.getFlags().contains(NDescriptorFlag.PLATFORM_APP);
    }

    @Override
    public Set<NDescriptorFlag> getFlags() {
        return this.flags;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isNoContent() {
        return "pom".equals(this.getPackaging());
    }

    @Override
    public String getSolver() {
        return this.solver;
    }

    @Override
    public NEnvCondition getCondition() {
        return this.condition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getIcons() {
        return this.icons;
    }

    @Override
    public String getGenericName() {
        return this.genericName;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<NIdLocation> getLocations() {
        return this.locations;
    }

    @Override
    public List<NDependency> getStandardDependencies() {
        return this.standardDependencies;
    }

    @Override
    public List<NDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public NArtifactCall getExecutor() {
        return this.executor;
    }

    @Override
    public NArtifactCall getInstaller() {
        return this.installer;
    }

    @Override
    public List<NDescriptorProperty> getProperties() {
        return this.properties;
    }

    @Override
    public NOptional<NDescriptorProperty> getProperty(String name) {
        if (this.properties == null) {
            return NOptional.ofNamedEmpty("property " + name);
        }
        return NOptional.ofNamed((NDescriptorProperty)this.properties.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null), "property " + name);
    }

    @Override
    public NOptional<NLiteral> getPropertyValue(String name) {
        return this.getProperty(name).map(NDescriptorProperty::getValue);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.idType, this.packaging, this.executor, this.installer, this.name, this.description, this.genericName, this.condition, this.flags, this.solver, this.categories, this.properties, this.icons, this.parents, this.locations, this.dependencies, this.standardDependencies, this.contributors, this.developers, this.licenses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNDescriptor that = (DefaultNDescriptor)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.idType, that.idType) && Objects.equals(this.parents, that.parents) && Objects.equals(this.solver, that.solver) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.executor, that.executor) && Objects.equals(this.installer, that.installer) && Objects.equals(this.name, that.name) && Objects.equals(this.icons, that.icons) && Objects.equals(this.categories, that.categories) && Objects.equals(this.genericName, that.genericName) && Objects.equals(this.description, that.description) && Objects.equals(this.condition, that.condition) && Objects.equals(this.locations, that.locations) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.flags, that.flags) && Objects.equals(this.properties, that.properties) && Objects.equals(this.contributors, that.contributors) && Objects.equals(this.developers, that.developers) && Objects.equals(this.licenses, that.licenses);
    }

    public String toString() {
        return "NDescriptor{id=" + this.id + ", idType=" + this.idType.id() + ", parents=" + this.parents + ", packaging='" + this.packaging + '\'' + ", executor=" + this.executor + ", flags=" + this.flags + ", installer=" + this.installer + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", condition=" + this.condition + ", locations=" + this.locations + ", dependencies=" + this.dependencies + ", standardDependencies=" + this.standardDependencies + ", icon=" + this.icons + ", category=" + this.categories + ", genericName=" + this.genericName + ", properties=" + this.properties + ", solver=" + this.solver + ", contributors=" + this.contributors + ", developers=" + this.developers + ", licenses=" + this.licenses + '}';
    }

    @Override
    public NDescriptorBuilder builder() {
        return new DefaultNDescriptorBuilder().copyFrom(this);
    }

    @Override
    public List<NDescriptorContributor> getContributors() {
        return this.contributors;
    }

    @Override
    public List<NDescriptorContributor> getDevelopers() {
        return this.developers;
    }

    @Override
    public List<NDescriptorLicense> getLicenses() {
        return this.licenses;
    }

    @Override
    public List<NDescriptorMailingList> getMailingLists() {
        return this.mailingLists;
    }

    @Override
    public NDescriptorOrganization getOrganization() {
        return this.organization;
    }
}

