/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDependency
implements NDependency {
    public static final long serialVersionUID = 1L;
    private final String repository;
    private final String groupId;
    private final String artifactId;
    private final NVersion version;
    private final String scope;
    private final String classifier;
    private final String optional;
    private final String type;
    private final List<NId> exclusions;
    private final String properties;
    private final NEnvCondition condition;

    public DefaultNDependency(String repository, String groupId, String artifactId, String classifier, NVersion version, String scope, String optional, List<NId> exclusions, NEnvCondition condition, String type, Map<String, String> properties) {
        this(repository, groupId, artifactId, classifier, version, scope, optional, exclusions, condition, type, NStringMapFormat.DEFAULT.format(properties));
    }

    public DefaultNDependency(String repository, String groupId, String artifactId, String classifier, NVersion version, String scope, String optional, List<NId> exclusions, NEnvCondition condition, String type, String properties) {
        this.repository = NStringUtils.trimToNull(repository);
        this.groupId = NStringUtils.trimToNull(groupId);
        this.artifactId = NStringUtils.trimToNull(artifactId);
        this.version = version == null ? NVersion.BLANK : version;
        this.classifier = NStringUtils.trimToNull(classifier);
        this.scope = NDependencyScope.parse(scope).orElse(NDependencyScope.API).id();
        String validOptional = NStringUtils.trimToNull(optional);
        if ("false".equalsIgnoreCase(validOptional)) {
            validOptional = null;
        } else if ("true".equalsIgnoreCase(validOptional)) {
            validOptional = "true";
        }
        NDependencyScopePattern s = NDependencyScopePattern.parse(scope).orElse(null);
        if (s != null && s == NDependencyScopePattern.SYSTEM) {
            validOptional = "true";
        }
        this.optional = validOptional;
        this.exclusions = NReservedLangUtils.unmodifiableList(exclusions);
        this.condition = condition == null ? NEnvCondition.BLANK : condition;
        this.type = NStringUtils.trimToNull(type);
        Map<String, String> m = NStringMapFormat.DEFAULT.parse(properties).get();
        block12: for (String k : new String[]{"scope", "optional", "type", "repo"}) {
            String old = m.remove(k);
            if (old == null) continue;
            switch (k) {
                case "scope": {
                    if (Objects.equals(old, scope) || Objects.equals(old, this.scope)) continue block12;
                    Logger.getLogger(DefaultNDependency.class.getName()).log(Level.WARNING, "unexpected dependency key : {0} {1}<>{2},{3}", new Object[]{k, old, scope, this.scope});
                    continue block12;
                }
                case "optional": {
                    if (Objects.equals(old, optional) || Objects.equals(old, this.optional)) continue block12;
                    Logger.getLogger(DefaultNDependency.class.getName()).log(Level.WARNING, "unexpected dependency key : {0} {1}<>{2},{3}", new Object[]{k, old, optional, this.optional});
                    continue block12;
                }
                case "type": {
                    if (Objects.equals(old, type) || Objects.equals(old, this.type)) continue block12;
                    Logger.getLogger(DefaultNDependency.class.getName()).log(Level.WARNING, "unexpected dependency key : {0} {1}<>{2},{3}", new Object[]{k, old, type, this.type});
                    continue block12;
                }
                case "repo": {
                    if (Objects.equals(old, repository) || Objects.equals(old, this.repository)) continue block12;
                    Logger.getLogger(DefaultNDependency.class.getName()).log(Level.WARNING, "unexpected dependency key : {0} {1}<>{2},{3}", new Object[]{k, old, repository, this.repository});
                }
            }
        }
        this.properties = NStringUtils.trim(NStringMapFormat.DEFAULT.format(m));
    }

    @Override
    public boolean isBlank() {
        return this.toId().isBlank();
    }

    @Override
    public NDependencyBuilder builder() {
        return NDependencyBuilder.of().copyFrom(this);
    }

    @Override
    public boolean isOptional() {
        String o = this.getOptional();
        return o != null && Boolean.parseBoolean(o);
    }

    @Override
    public String getOptional() {
        return this.optional;
    }

    @Override
    public boolean isAnyProvided() {
        if (!NBlankable.isBlank(this.scope)) {
            NDependencyScopePattern u = NDependencyScopePattern.parse(this.getScope()).orElse(null);
            if (u != null) {
                switch (u) {
                    case PROVIDED: 
                    case TEST_PROVIDED: {
                        return true;
                    }
                }
            }
            return u == NDependencyScopePattern.PROVIDED;
        }
        return false;
    }

    @Override
    public boolean isAnyRuntime() {
        if (!NBlankable.isBlank(this.scope)) {
            NDependencyScopePattern u = NDependencyScopePattern.parse(this.getScope()).orElse(null);
            if (u != null) {
                switch (u) {
                    case RUNTIME: 
                    case TEST_RUNTIME: {
                        return true;
                    }
                }
            }
            return u == NDependencyScopePattern.PROVIDED;
        }
        return false;
    }

    @Override
    public boolean isProvided() {
        NDependencyScopePattern u;
        if (!NBlankable.isBlank(this.scope) && (u = (NDependencyScopePattern)NDependencyScopePattern.parse(this.getScope()).orElse(null)) != null) {
            switch (u) {
                case PROVIDED: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isRuntime() {
        NDependencyScopePattern u;
        if (!NBlankable.isBlank(this.scope) && (u = (NDependencyScopePattern)NDependencyScopePattern.parse(this.getScope()).orElse(null)) != null) {
            switch (u) {
                case RUNTIME: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isAnyTest() {
        NDependencyScopePattern u;
        if (!NBlankable.isBlank(this.scope) && (u = (NDependencyScopePattern)NDependencyScopePattern.parse(this.getScope()).orElse(null)) != null) {
            switch (u) {
                case TEST_PROVIDED: 
                case TEST_RUNTIME: 
                case TEST: 
                case TEST_COMPILE: 
                case TEST_IMPLEMENTATION: 
                case TEST_SYSTEM: 
                case TEST_OTHER: 
                case TEST_API: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public NId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        Map<String, String> pp = this.getProperties();
        m.putAll(pp);
        if (!NReservedUtils.isDependencyDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NBlankable.isBlank(this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NBlankable.isBlank(this.type)) {
            m.put("type", this.type);
        }
        if (!NBlankable.isBlank(this.repository)) {
            m.put("repo", this.repository);
        }
        if (this.exclusions.size() > 0) {
            m.put("exclusions", NReservedUtils.toDependencyExclusionListString(this.exclusions));
        }
        NId ii = NIdBuilder.of().setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setClassifier(this.getClassifier()).setVersion(this.getVersion()).setCondition(this.getCondition()).setProperties(m).build();
        return ii;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getShortName() {
        return NReservedUtils.getIdShortName(this.groupId, this.artifactId, this.classifier);
    }

    @Override
    public String getLongName() {
        return NReservedUtils.getIdLongName(this.groupId, this.artifactId, this.version, this.classifier);
    }

    @Override
    public String getFullName() {
        return this.toString();
    }

    @Override
    public NVersion getVersion() {
        return this.version;
    }

    @Override
    public NEnvCondition getCondition() {
        return this.condition;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<NId> getExclusions() {
        return this.exclusions;
    }

    @Override
    public String getPropertiesQuery() {
        return this.properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return NStringMapFormat.DEFAULT.parse(this.properties).get();
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.groupId, this.artifactId, this.version, this.scope, this.classifier, this.optional, this.type, this.properties, this.condition, this.exclusions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNDependency that = (DefaultNDependency)o;
        return Objects.equals(this.repository, that.repository) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.scope, that.scope) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.optional, that.optional) && Objects.equals(this.type, that.type) && Objects.equals(this.exclusions, that.exclusions) && Objects.equals(this.properties, that.properties) && Objects.equals(this.condition, that.condition);
    }

    public String toString() {
        return this.toId().toString();
    }
}

