/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.optional.jansi;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.platform.NOsFamily;
import org.fusesource.jansi.AnsiConsole;

public class OptionalJansi {
    public static boolean isatty(int fd) {
        try {
            Class<?> cc = Class.forName("org.fusesource.jansi.internal.CLibrary");
            Method m = cc.getDeclaredMethod("isatty", Integer.TYPE);
            int b = (Integer)m.invoke(null, fd);
            return b != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAvailable() {
        if (NOsFamily.getCurrent() == NOsFamily.WINDOWS) {
            try {
                Class.forName("org.fusesource.jansi.io.AnsiOutputStream");
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static NWorkspaceTerminalOptions resolveStdFd(InputStream in, PrintStream out, PrintStream err, List<String> flags) {
        boolean tty = flags.contains("tty");
        if (OptionalJansi.isAvailable()) {
            flags.add("jansi");
            if (System.console() != null) {
                AnsiConsole.systemInstall();
                flags.add("ansi");
                return new NWorkspaceTerminalOptions(System.in, System.out, System.err, flags.toArray(new String[0]));
            }
            if (tty) {
                flags.add("ansi");
            } else {
                flags.add("raw");
            }
            return new NWorkspaceTerminalOptions(System.in, System.out, System.err, flags.toArray(new String[0]));
        }
        return null;
    }

    public static void fillAnsiFlags(Set<String> flags) {
        boolean tty = flags.contains("tty");
        if (OptionalJansi.isAvailable()) {
            flags.add("jansi");
            if (System.console() != null) {
                AnsiConsole.systemInstall();
                flags.add("ansi");
            } else if (tty) {
                flags.add("ansi");
            } else {
                flags.add("raw");
            }
        }
    }
}

