/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.reflect;

import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectType;

public class NSignature {
    private NReflectType[] types;
    private boolean vararg;

    public static NSignature of(NReflectType ... types) {
        return new NSignature(types, false);
    }

    public static NSignature ofVarArgs(NReflectType ... types) {
        NSignature.checkVararg(types);
        return new NSignature(types, true);
    }

    private static void checkVararg(NReflectType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("invalid vararg with zero length arguments");
        }
        NReflectType lastType = types[types.length - 1];
        if (!lastType.isArrayType()) {
            throw new IllegalArgumentException("last argument must be a valid array for vararg methods");
        }
    }

    private NSignature(NReflectType[] types, boolean vararg) {
        this.types = types;
        this.vararg = vararg;
    }

    public NReflectType getType(int index) {
        return this.types[index];
    }

    public NSignature setVararg(boolean vararg) {
        if (this.vararg == vararg) {
            return this;
        }
        if (vararg) {
            NSignature.checkVararg(this.types);
        }
        NReflectType[] types2 = Arrays.copyOfRange(this.types, 0, this.types.length);
        return new NSignature(types2, vararg);
    }

    public NSignature set(NReflectType any, int pos) {
        NReflectType[] types2 = Arrays.copyOfRange(this.types, 0, this.types.length);
        types2[pos] = any;
        if (this.vararg) {
            NSignature.checkVararg(types2);
        }
        return new NSignature(types2, this.vararg);
    }

    public int size() {
        return this.types.length;
    }

    public NReflectType[] types() {
        return this.types;
    }

    public boolean isVarArgs() {
        return this.vararg;
    }

    public String toString() {
        if (this.types.length == 0) {
            return "()";
        }
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (this.vararg) {
            if (this.types.length == 1) {
                b.append(this.strOfType(this.types[0]));
                b.append("...");
            } else {
                b.append(this.strOfType(this.types[0]));
                for (int i = 1; i < this.types.length - 1; ++i) {
                    b.append(",");
                    b.append(this.strOfType(this.types[i]));
                }
                b.append(this.strOfType(this.types[this.types.length - 1]));
                b.append("...");
            }
        } else {
            b.append(this.types[0]);
            for (int i = 1; i < this.types.length; ++i) {
                b.append(",");
                b.append(this.strOfType(this.types[i]));
            }
        }
        return b.append(')').toString();
    }

    private String strOfType(NReflectType t) {
        return t.getName();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NSignature nSig = (NSignature)o;
        return this.vararg == nSig.vararg && Objects.deepEquals(this.types, nSig.types);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.types), this.vararg);
    }
}

