/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.reflect.NPlatformArgsSignature;
import net.thevpc.nuts.reflect.NReflectUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NOptionalMap;

public class NPlatformSignatureMap<V> {
    private final Map<Integer, NSigMapBySize<V>> map = new HashMap<Integer, NSigMapBySize<V>>();
    private Class<V> valueType;

    public NPlatformSignatureMap(Class<V> valueType) {
        this.valueType = valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMulti(NPlatformArgsSignature sig, V value, NPlatformArgsSignature ... sigs) {
        NAssert.requireNonNull(sig);
        Map<Integer, NSigMapBySize<V>> map = this.map;
        synchronized (map) {
            int usize = sig.size();
            NSigMapBySize<V> m = this.map.get(usize);
            if (m == null) {
                m = new NSigMapBySize(usize);
                this.map.put(usize, m);
            }
            m.put(sig, value);
            if (sigs != null) {
                for (NPlatformArgsSignature nSig : sigs) {
                    if (nSig == null) continue;
                    m.put(nSig, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(NPlatformArgsSignature sig, V value) {
        NAssert.requireNonNull(sig);
        Map<Integer, NSigMapBySize<V>> map = this.map;
        synchronized (map) {
            int usize = sig.size();
            NSigMapBySize<V> m = this.map.get(usize);
            if (m == null) {
                m = new NSigMapBySize(usize);
                this.map.put(usize, m);
            }
            m.put(sig, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NOptional<V> get(NPlatformArgsSignature sig) {
        NAssert.requireNonNull(sig);
        Map<Integer, NSigMapBySize<V>> map = this.map;
        synchronized (map) {
            NSigMapBySize<V> m = this.map.get(sig.size());
            if (m == null) {
                return NOptional.ofNamedEmpty(NMsg.ofC("%s", sig));
            }
            return m.get(sig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NPlatformArgsSignature sig) {
        NAssert.requireNonNull(sig);
        Map<Integer, NSigMapBySize<V>> map = this.map;
        synchronized (map) {
            NSigMapBySize<V> m = this.map.get(sig.size());
            if (m == null) {
                return;
            }
            m.remove(sig);
        }
    }

    public Map<NPlatformArgsSignature, V> toMap() {
        HashMap all = new HashMap();
        for (Map.Entry<Integer, NSigMapBySize<V>> e : this.map.entrySet()) {
            all.putAll(((NSigMapBySize)e.getValue()).map.toMap());
        }
        return all;
    }

    public int size() {
        int s = 0;
        for (Map.Entry<Integer, NSigMapBySize<V>> e : this.map.entrySet()) {
            s += ((NSigMapBySize)e.getValue()).map.size();
        }
        return s;
    }

    private static class NSigMapBySize<V> {
        private NOptionalMap<NPlatformArgsSignature, V> map = new NOptionalMap();
        private int count;
        private boolean invalidCache;
        private Map<NPlatformArgsSignature, ValueWithDistance<V>> cache = new HashMap<NPlatformArgsSignature, ValueWithDistance<V>>();
        private Set<NPlatformArgsSignature> findInProgress = new HashSet<NPlatformArgsSignature>();

        public NSigMapBySize(int count) {
            this.count = count;
        }

        public NOptional<V> get(NPlatformArgsSignature sig) {
            if (this.invalidCache) {
                NOptional<V> v = this.map.get(sig);
                if (v.isPresent()) {
                    return v;
                }
                this.cache.clear();
            } else {
                ValueWithDistance<V> o = this.cache.get(sig);
                if (o != null) {
                    return NOptional.ofNullable(o.getValueNonAmbiguous());
                }
                NOptional<V> v = this.map.get(sig);
                if (v.isPresent()) {
                    this.cache.put(sig, ValueWithDistance.ofSimple(sig, sig, 0, v.get()));
                    return v;
                }
            }
            ValueWithDistance<V> vd = this.find(sig, 0);
            if (vd == null) {
                vd = ValueWithDistance.ofEmpty(sig);
                this.cache.put(sig, vd);
            }
            return NOptional.ofNullable(vd.getValueNonAmbiguous());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ValueWithDistance<V> find(NPlatformArgsSignature sig, int distance) {
            if (this.findInProgress.contains(sig)) {
                return null;
            }
            try {
                ValueWithDistance r;
                this.findInProgress.add(sig);
                NOptional<V> v = this.map.get(sig);
                if (v.isPresent()) {
                    ValueWithDistance<V> valueWithDistance = ValueWithDistance.ofSimple(sig, sig, distance, v.get());
                    return valueWithDistance;
                }
                ValueWithDistanceBestResolver bestResolver = new ValueWithDistanceBestResolver();
                for (int i = 0; i < sig.size(); ++i) {
                    Type t = sig.getType(i);
                    if (t instanceof Class) {
                        Class c = (Class)t;
                        this.findClassAtPos(sig, i, c, bestResolver, distance);
                        continue;
                    }
                    if (!(t instanceof GenericArrayType) && !(t instanceof TypeVariable) && !(t instanceof ParameterizedType) && !(t instanceof ParameterizedType) && !(t instanceof WildcardType)) continue;
                }
                ValueWithDistance valueWithDistance = r = ValueWithDistance.ofPointers(sig, distance, bestResolver.best);
                return valueWithDistance;
            }
            finally {
                this.findInProgress.remove(sig);
            }
        }

        private void findClassAtPos(NPlatformArgsSignature sig, int i, Class c, ValueWithDistanceBestResolver<V> bestResolver, int distance) {
            Class<?>[] superInterfaces;
            ValueWithDistance<V> vd;
            NOptional<Class<?>> bt;
            if (c.isPrimitive()) {
                bt = NReflectUtils.toBoxedType(c);
                vd = this.find(sig.set(bt.get(), i), distance + 1);
                bestResolver.add(vd);
            } else {
                bt = NReflectUtils.toPrimitiveType(c);
                if (bt.isPresent()) {
                    vd = this.find(sig.set(bt.get(), i), distance + 1);
                    bestResolver.add(vd);
                }
            }
            Class sc = c.getSuperclass();
            if (sc != null) {
                vd = this.find(sig.set(sc, i), distance + 2);
                bestResolver.add(vd);
            }
            for (Class<?> si : superInterfaces = c.getInterfaces()) {
                ValueWithDistance<V> vd2 = this.find(sig.set(si, i), distance + 2);
                bestResolver.add(vd2);
            }
        }

        public NOptional<V> remove(NPlatformArgsSignature uplet) {
            NOptional<V> r = this.map.remove(uplet);
            if (r.isPresent()) {
                this.invalidCache = true;
            }
            return r;
        }

        public void put(NPlatformArgsSignature uplet, V value) {
            NOptional<V> o = this.map.put(uplet, value);
            if (!o.isPresent() || !Objects.equals(o.orNull(), value)) {
                this.invalidCache = true;
            }
        }
    }

    private static class ValueWithDistance<V> {
        NPlatformArgsSignature key;
        NPlatformArgsSignature effKey;
        V value;
        List<ValueWithDistance<V>> pointers;
        int distance;
        boolean empty;

        public static <V> ValueWithDistance<V> ofSimple(NPlatformArgsSignature key, NPlatformArgsSignature effKey, int distance, V value) {
            return new ValueWithDistance<V>(key, effKey, value, null, distance, false);
        }

        public static <V> ValueWithDistance<V> ofPointers(NPlatformArgsSignature key, int distance, List<ValueWithDistance<V>> values) {
            if (values.size() == 0) {
                return ValueWithDistance.ofEmpty(key);
            }
            V value = null;
            NPlatformArgsSignature effKey1 = key;
            if (values.size() == 1) {
                value = values.get((int)0).value;
                effKey1 = values.get((int)0).effKey;
            }
            if (values.size() > 1) {
                LinkedHashMap<NPlatformArgsSignature, ValueWithDistance<V>> valuesMap = new LinkedHashMap<NPlatformArgsSignature, ValueWithDistance<V>>();
                for (ValueWithDistance<V> v : values) {
                    if (valuesMap.containsKey(v.effKey)) continue;
                    valuesMap.put(v.effKey, v);
                }
                values = new ArrayList(valuesMap.values());
            }
            if (values.size() > 1) {
                HashSet<V> fcts = new HashSet<V>();
                ArrayList<ValueWithDistance<V>> newValues = new ArrayList<ValueWithDistance<V>>();
                for (ValueWithDistance<V> v : values) {
                    if (fcts.contains(v.value)) continue;
                    fcts.add(v.value);
                    newValues.add(v);
                }
                values = newValues;
            }
            if (values.size() > 1) {
                value = values.get((int)0).value;
                effKey1 = values.get((int)0).effKey;
            }
            return new ValueWithDistance<Object>(key, effKey1, value, (List<ValueWithDistance<Object>>)values, distance, false);
        }

        public static <V> ValueWithDistance<V> ofEmpty(NPlatformArgsSignature key) {
            return new ValueWithDistance<Object>(key, key, null, null, 0, true);
        }

        public ValueWithDistance(NPlatformArgsSignature key, NPlatformArgsSignature effKey, V value, List<ValueWithDistance<V>> values, int distance, boolean empty) {
            this.key = key;
            this.effKey = effKey;
            this.value = value;
            this.pointers = values;
            this.distance = distance;
            this.empty = empty;
        }

        public V getValueNonAmbiguous() {
            if (this.pointers != null && this.pointers.size() > 1) {
                throw new IllegalArgumentException(NMsg.ofC("Not a single value %s : %s", this.key, this.pointers.stream().map(x -> x.key).collect(Collectors.toList())).toString());
            }
            if (this.pointers != null && this.pointers.size() == 1) {
                return this.pointers.get(0).getValueNonAmbiguous();
            }
            return this.value;
        }

        public boolean isPresent() {
            return !this.empty;
        }
    }

    private static class ValueWithDistanceBestResolver<V> {
        List<ValueWithDistance<V>> best = new ArrayList<ValueWithDistance<V>>();
        int bestDistance = -1;

        private ValueWithDistanceBestResolver() {
        }

        public void add(ValueWithDistance<V> vd) {
            if (vd != null && vd.isPresent()) {
                if (this.bestDistance < 0 || this.bestDistance > vd.distance) {
                    this.bestDistance = vd.distance;
                    this.best.clear();
                    if (vd.pointers == null) {
                        this.best.add(vd);
                    } else {
                        this.best.addAll(vd.pointers.stream().map(x -> ValueWithDistance.ofSimple(vd.key, vd.effKey, vd.distance, x.value)).collect(Collectors.toList()));
                    }
                } else if (this.bestDistance == vd.distance) {
                    if (vd.pointers == null) {
                        this.best.add(vd);
                    } else {
                        this.best.addAll(vd.pointers.stream().map(x -> ValueWithDistance.ofSimple(vd.key, vd.effKey, vd.distance, x.value)).collect(Collectors.toList()));
                    }
                }
            }
        }
    }
}

