/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectUtils;

public class NPlatformArgsSignature {
    private Type[] types;
    private boolean vararg;

    public static NPlatformArgsSignature of(Type ... types) {
        return new NPlatformArgsSignature(types, false);
    }

    public static NPlatformArgsSignature ofVarArgs(Type ... types) {
        NPlatformArgsSignature.checkVararg(types);
        return new NPlatformArgsSignature(types, true);
    }

    private static void checkVararg(Type ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("invalid vararg with zero length arguments");
        }
        Type lastType = types[types.length - 1];
        if (!(lastType instanceof Class)) {
            throw new IllegalArgumentException("last argument must be a valid array for vararg methods");
        }
        if (!(lastType instanceof GenericArrayType || lastType instanceof Class && ((Class)lastType).isArray())) {
            throw new IllegalArgumentException("last argument must be a valid array for vararg methods");
        }
    }

    private NPlatformArgsSignature(Type[] types, boolean vararg) {
        this.types = types;
        this.vararg = vararg;
    }

    public Type getType(int index) {
        return this.types[index];
    }

    public NPlatformArgsSignature setVararg(boolean vararg) {
        if (vararg) {
            NPlatformArgsSignature.checkVararg(this.types);
        }
        Type[] types2 = Arrays.copyOfRange(this.types, 0, this.types.length);
        return new NPlatformArgsSignature(types2, vararg);
    }

    public NPlatformArgsSignature set(Type any, int pos) {
        Type[] types2 = Arrays.copyOfRange(this.types, 0, this.types.length);
        types2[pos] = any;
        if (this.vararg) {
            NPlatformArgsSignature.checkVararg(types2);
        }
        return new NPlatformArgsSignature(types2, this.vararg);
    }

    public int size() {
        return this.types.length;
    }

    public Type[] types() {
        return this.types;
    }

    public boolean isVararg() {
        return this.vararg;
    }

    public String toString() {
        if (this.types.length == 0) {
            return "()";
        }
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (this.vararg) {
            if (this.types.length == 1) {
                b.append(this.strOfType(this.types[0]));
                b.append("...");
            } else {
                b.append(this.strOfType(this.types[0]));
                for (int i = 1; i < this.types.length - 1; ++i) {
                    b.append(",");
                    b.append(this.strOfType(this.types[i]));
                }
                b.append(this.strOfType(this.types[this.types.length - 1]));
                b.append("...");
            }
        } else {
            b.append(this.types[0]);
            for (int i = 1; i < this.types.length; ++i) {
                b.append(",");
                b.append(this.strOfType(this.types[i]));
            }
        }
        return b.append(')').toString();
    }

    private String strOfType(Type t) {
        if (t instanceof Class) {
            return ((Class)t).getName();
        }
        return t == null ? "null" : t.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPlatformArgsSignature nSig = (NPlatformArgsSignature)o;
        return this.vararg == nSig.vararg && Objects.deepEquals(this.types, nSig.types);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.types), this.vararg);
    }

    public boolean matches(NPlatformArgsSignature other) {
        int mySize = this.size();
        boolean vararg1 = this.isVararg();
        if (vararg1 && other.size() == mySize - 1) {
            for (int i = 0; i < mySize - 1; ++i) {
                if (this.typeMatches(this.types[i], other.types[i], false)) continue;
                return false;
            }
            return true;
        }
        if (mySize != other.size()) {
            return false;
        }
        for (int i = 0; i < mySize; ++i) {
            if (this.typeMatches(this.types[i], other.types[i], vararg1 && i == mySize - 1)) continue;
            return false;
        }
        return true;
    }

    private boolean typeMatches(Type a, Type b, boolean varArg) {
        if (a == null) {
            return true;
        }
        if (b == null) {
            return true;
        }
        if (a instanceof Class && b instanceof Class) {
            Class ca = (Class)a;
            Class cb = (Class)b;
            if (ca.isPrimitive() || cb.isPrimitive()) {
                return this.typeMatches(NReflectUtils.toBoxedType(ca).orElse(ca), NReflectUtils.toBoxedType(cb).orElse(cb), false);
            }
            if (ca.isAssignableFrom(cb)) {
                return true;
            }
            if (varArg && ca.isArray() && this.typeMatches(ca.getComponentType(), cb, false)) {
                return true;
            }
        }
        return false;
    }
}

