/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import java.util.List;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public enum NShellFamily implements NEnum
{
    SH,
    BASH,
    CSH,
    KSH,
    ZSH,
    FISH,
    WIN_CMD,
    WIN_POWER_SHELL,
    UNKNOWN;

    private static final NShellFamily _curr;
    private final String id = NNameFormat.ID_NAME.format(this.name());

    private static NShellFamily _resolveCurrent() {
        switch (NOsFamily.getCurrent()) {
            case WINDOWS: {
                return WIN_CMD;
            }
            case LINUX: 
            case UNIX: {
                return NShellFamily.parse(System.getenv("SHELL")).orElse(BASH);
            }
            case MACOS: {
                return NShellFamily.parse(System.getenv("SHELL")).orElse(ZSH);
            }
        }
        return UNKNOWN;
    }

    public static NOptional<NShellFamily> parse(String value) {
        return NEnumUtils.parseEnum(value, NShellFamily.class, s -> {
            List<String> parts;
            String n = null;
            n = s.getValue().contains("/") ? ((parts = NStringUtils.split(s.getValue().trim().toUpperCase(), "/", true, true)).size() > 0 ? parts.get(parts.size() - 1) : "") : s.getNormalizedValue();
            switch (n) {
                case "": {
                    return NOptional.ofEmpty(() -> NMsg.ofC("%s is empty", NShellFamily.class.getSimpleName()));
                }
                case "SH": {
                    return NOptional.of(SH);
                }
                case "BASH": {
                    return NOptional.of(BASH);
                }
                case "CSH": {
                    return NOptional.of(CSH);
                }
                case "KSH": {
                    return NOptional.of(KSH);
                }
                case "ZSH": {
                    return NOptional.of(ZSH);
                }
                case "FISH": {
                    return NOptional.of(FISH);
                }
                case "WINDOWS_CMD": 
                case "WIN_CMD": 
                case "CMD": 
                case "WIN": {
                    return NOptional.of(WIN_CMD);
                }
                case "WINDOWS_POWER_SHELL": 
                case "WINDOWS_POWERSHELL": 
                case "WIN_POWER_SHELL": 
                case "WIN_POWERSHELL": 
                case "POWER_SHELL": 
                case "POWERSHELL": {
                    return NOptional.of(WIN_POWER_SHELL);
                }
            }
            return null;
        });
    }

    public static NShellFamily getCurrent() {
        return _curr;
    }

    @Override
    public String id() {
        return this.id;
    }

    static {
        _curr = NShellFamily._resolveCurrent();
    }
}

