/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NStringUtils;

public class NPlatformHome {
    public static final NPlatformHome USER = NPlatformHome.of(null);
    public static final NPlatformHome SYSTEM = NPlatformHome.ofSystem(null);
    private final NOsFamily platformOsFamily;
    private final boolean system;
    private final Function<String, String> env;
    private final Function<String, String> props;
    private final String sysPrefix = "system";

    public static NPlatformHome ofSystem(NOsFamily platformOsFamily, Function<String, String> env, Function<String, String> props) {
        return new NPlatformHome(platformOsFamily, true, env, props);
    }

    public static NPlatformHome of(NOsFamily platformOsFamily, Function<String, String> env, Function<String, String> props) {
        return new NPlatformHome(platformOsFamily, false, env, props);
    }

    public static NPlatformHome ofSystem(NOsFamily platformOsFamily) {
        return new NPlatformHome(platformOsFamily, true, null, null);
    }

    public static NPlatformHome of(NOsFamily platformOsFamily) {
        return new NPlatformHome(platformOsFamily, false, null, null);
    }

    public static NPlatformHome of(NOsFamily platformOsFamily, boolean system) {
        return new NPlatformHome(platformOsFamily, system, null, null);
    }

    public static NPlatformHome ofPortable(NOsFamily platformOsFamily, String userName) {
        return NPlatformHome.ofPortable(platformOsFamily, false, userName);
    }

    public static NPlatformHome ofPortableSystem(NOsFamily platformOsFamily, String userName) {
        return NPlatformHome.ofPortable(platformOsFamily, true, userName);
    }

    public static NPlatformHome ofPortable(NOsFamily platformOsFamily, boolean system, String userName) {
        NAssert.requireNonBlank(userName, "userName");
        return new NPlatformHome(platformOsFamily, system, p -> null, p -> NPlatformHome.portableProp(p, platformOsFamily, null, x -> {
            switch (x) {
                case "user.name": {
                    return userName;
                }
            }
            return null;
        }));
    }

    public static NPlatformHome ofPortable(NOsFamily platformOsFamily, boolean system, Function<String, String> env, Function<String, String> props) {
        return new NPlatformHome(platformOsFamily, system, p -> null, p -> NPlatformHome.portableProp(p, platformOsFamily, env, props));
    }

    private static String portableProp(String p, NOsFamily platformOsFamily, Function<String, String> env, Function<String, String> props) {
        NOsFamily osFamily = platformOsFamily == null ? NOsFamily.UNIX : platformOsFamily;
        switch (p) {
            case "user.name": {
                String userName = NAssert.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name");
                return userName;
            }
            case "user.home": {
                String userName;
                String home;
                String string = home = props == null ? null : props.apply("user.home");
                if (!NBlankable.isBlank(home)) {
                    return home;
                }
                switch (osFamily) {
                    case WINDOWS: {
                        String userName2 = NAssert.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name");
                        return "C:\\Users\\" + userName2;
                    }
                }
                switch (userName = (String)NAssert.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name")) {
                    case "root": {
                        return "/root";
                    }
                }
                return "/home/" + userName;
            }
            case "java.io.tmpdir": {
                String temp;
                String string = temp = props == null ? null : props.apply("java.io.tmpdir");
                if (!NBlankable.isBlank(temp)) {
                    return temp;
                }
                switch (osFamily) {
                    case WINDOWS: {
                        String userName = NAssert.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name");
                        return "C:\\Users\\" + userName + "\\AppData\\Local\\Temp";
                    }
                }
                return "/tmp";
            }
        }
        return null;
    }

    public NPlatformHome(NOsFamily platformOsFamily, boolean system, Function<String, String> env, Function<String, String> props) {
        this.platformOsFamily = platformOsFamily != null ? platformOsFamily : NOsFamily.getCurrent();
        this.system = system;
        this.env = env != null ? env : System::getenv;
        this.props = props != null ? props : System::getProperty;
    }

    public String getCustomPlatformHomeFolder(NStoreType location, Map<NHomeLocation, String> homeLocations) {
        if (location == null) {
            return null;
        }
        String locationName = location.id();
        String s = NStringUtils.trim(this.props.apply("nuts.home." + locationName + "." + this.platformOsFamily.id()));
        if (!s.isEmpty()) {
            return s;
        }
        s = NStringUtils.trim(this.props.apply("nuts.export.home." + locationName + "." + this.platformOsFamily.id()));
        if (!s.isEmpty()) {
            return s;
        }
        if (homeLocations != null && homeLocations.size() > 0) {
            NHomeLocation key = NHomeLocation.of(this.platformOsFamily, location);
            s = NStringUtils.trim(homeLocations.get(key));
            if (!s.isEmpty()) {
                return s;
            }
            key = NHomeLocation.of(null, location);
            s = NStringUtils.trim(homeLocations.get(key));
            if (!s.isEmpty()) {
                return s;
            }
        }
        return null;
    }

    public String getWorkspaceLocation(NStoreType location, Map<NHomeLocation, String> homeLocations, String workspaceName) {
        if (location == null) {
            return this.getWorkspaceLocation(workspaceName);
        }
        String s = this.getCustomPlatformHomeFolder(location, homeLocations);
        if (s != null) {
            return s;
        }
        return this.getWorkspaceStore(location, workspaceName);
    }

    public String getWorkspaceLocation(String workspaceName) {
        if (NBlankable.isBlank(workspaceName)) {
            workspaceName = "default-workspace";
        } else if (workspaceName.equals(".") || workspaceName.equals("..") || workspaceName.indexOf(47) >= 0 || workspaceName.indexOf(92) >= 0) {
            return Paths.get(workspaceName, new String[0]).normalize().toAbsolutePath().toString();
        }
        return this.getHome() + this.getNativePath("/ws/" + workspaceName);
    }

    public String getHome() {
        if (this.system) {
            switch (this.platformOsFamily) {
                case WINDOWS: {
                    return this.getWindowsProgramFiles() + "\\nuts";
                }
            }
            return "/etc/opt/nuts";
        }
        String userHome = this.props.apply("user.home");
        return userHome + this.getNativePath("/.nuts");
    }

    public String getWorkspaceStore(NStoreType location, String workspaceName) {
        Path fileName;
        if (location == null) {
            return this.getWorkspaceLocation(workspaceName);
        }
        workspaceName = NBlankable.isBlank(workspaceName) ? "default-workspace" : ((fileName = Paths.get(workspaceName, new String[0]).normalize().toAbsolutePath().getFileName()) == null ? "default-workspace" : fileName.toString());
        return this.getStore(location) + this.getNativePath("/ws/" + this.getNativePath(workspaceName));
    }

    public String getStore(NStoreType location) {
        if (location == null) {
            return this.getHome();
        }
        NOsFamily platformOsFamily = this.platformOsFamily;
        if (platformOsFamily == null) {
            platformOsFamily = NOsFamily.getCurrent();
        }
        String locationName = location.id();
        if (this.system) {
            String s = null;
            s = NStringUtils.trim(this.props.apply("nuts.store.system." + locationName + "." + platformOsFamily.id()));
            if (!s.isEmpty()) {
                return s;
            }
            s = NStringUtils.trim(this.props.apply("nuts.export.store.system." + locationName + "." + platformOsFamily.id()));
            if (!s.isEmpty()) {
                return s.trim();
            }
            switch (location) {
                case BIN: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationName;
                        }
                    }
                    return "/opt/nuts/" + locationName;
                }
                case LIB: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationName;
                        }
                    }
                    return "/opt/nuts/" + locationName;
                }
                case CONF: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationName;
                        }
                    }
                    return "/etc/opt/nuts/" + locationName;
                }
                case LOG: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationName;
                        }
                    }
                    return "/var/log/nuts";
                }
                case CACHE: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationName;
                        }
                    }
                    return "/var/cache/nuts";
                }
                case VAR: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationName;
                        }
                    }
                    return "/var/opt/nuts";
                }
                case TEMP: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            String pf = this.env.apply("TMP");
                            if (NBlankable.isBlank(pf)) {
                                pf = this.getWindowsSystemRoot() + "\\Temp";
                            }
                            return pf + "\\nuts";
                        }
                    }
                    return "/tmp/nuts/system";
                }
                case RUN: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            String pf = this.env.apply("TMP");
                            if (NBlankable.isBlank(pf)) {
                                pf = this.getWindowsSystemRoot() + "\\Temp";
                            }
                            return pf + "\\nuts\\run";
                        }
                    }
                    return "/tmp/run/nuts/system";
                }
            }
        } else {
            String userHome = this.props.apply("user.home");
            String userName = this.props.apply("user.name");
            switch (location) {
                case BIN: 
                case LIB: 
                case VAR: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return userHome + this.getNativePath("/AppData/Roaming/nuts/" + locationName);
                        }
                    }
                    String val = NStringUtils.trim(this.env.apply("XDG_DATA_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts/" + locationName;
                    }
                    return userHome + "/.local/share/nuts/" + locationName;
                }
                case LOG: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return userHome + this.getNativePath("/AppData/LocalLow/nuts/" + locationName);
                        }
                    }
                    String val = NStringUtils.trim(this.env.apply("XDG_LOG_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.local/log/nuts";
                }
                case RUN: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return userHome + this.getNativePath("/AppData/Local/nuts/" + locationName);
                        }
                    }
                    String val = NStringUtils.trim(this.env.apply("XDG_RUNTIME_DIR"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.local/run/nuts";
                }
                case CONF: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return userHome + this.getNativePath("/AppData/Roaming/nuts/" + locationName);
                        }
                    }
                    String val = NStringUtils.trim(this.env.apply("XDG_CONFIG_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.config/nuts";
                }
                case CACHE: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return userHome + this.getNativePath("/AppData/Local/nuts/cache");
                        }
                    }
                    String val = NStringUtils.trim(this.env.apply("XDG_CACHE_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.cache/nuts";
                }
                case TEMP: {
                    switch (platformOsFamily) {
                        case WINDOWS: {
                            return userHome + this.getNativePath("/AppData/Local/nuts/" + locationName);
                        }
                    }
                    return this.props.apply("java.io.tmpdir") + this.getNativePath("/" + userName + "/nuts");
                }
            }
        }
        throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("unsupported getDefaultPlatformHomeFolderBase %s/%s"), platformOsFamily, location));
    }

    public String getWindowsProgramFiles() {
        String s = this.env.apply("ProgramFiles");
        if (!NBlankable.isBlank(s)) {
            return s;
        }
        String c = this.getWindowsSystemDrive();
        if (!NBlankable.isBlank(c)) {
            return c + "\\Program Files";
        }
        return "C:\\Program Files";
    }

    public String getWindowsProgramFilesX86() {
        String s = this.env.apply("ProgramFiles(x86)");
        if (!NBlankable.isBlank(s)) {
            return s;
        }
        String c = this.getWindowsSystemDrive();
        if (!NBlankable.isBlank(c)) {
            return c + "\\Program Files (x86)";
        }
        return "C:\\Program Files (x86)";
    }

    public String getWindowsSystemRoot() {
        String e = this.env.apply("SystemRoot");
        if (!NBlankable.isBlank(e)) {
            return e;
        }
        e = this.env.apply("windir");
        if (!NBlankable.isBlank(e)) {
            return e;
        }
        e = this.env.apply("SystemDrive");
        if (!NBlankable.isBlank(e)) {
            return e + "\\Windows";
        }
        return "C:\\Windows";
    }

    public String getWindowsSystemDrive() {
        String e = this.env.apply("SystemDrive");
        if (!NBlankable.isBlank(e)) {
            return e;
        }
        e = this.env.apply("SystemRoot");
        if (!NBlankable.isBlank(e)) {
            return e.substring(0, 2);
        }
        e = this.env.apply("windir");
        if (!NBlankable.isBlank(e)) {
            return e.substring(0, 2);
        }
        return null;
    }

    private String getNativePath(String s) {
        switch (this.platformOsFamily) {
            case WINDOWS: {
                return s.replace('/', '\\');
            }
        }
        return s.replace('\\', '/');
    }

    public Map<NStoreType, String> buildLocations(NStoreStrategy storeStrategy, Map<NStoreType, String> baseLocations, Map<NHomeLocation, String> homeLocations, String workspaceLocation) {
        workspaceLocation = this.getWorkspaceLocation(workspaceLocation);
        String[] homes = new String[NStoreType.values().length];
        for (NStoreType location : NStoreType.values()) {
            String platformHomeFolder = this.getWorkspaceLocation(location, homeLocations, workspaceLocation);
            if (NBlankable.isBlank(platformHomeFolder)) {
                throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("missing Home for %s"), location.id()));
            }
            homes[location.ordinal()] = platformHomeFolder;
        }
        if (storeStrategy == null) {
            storeStrategy = NStoreStrategy.EXPLODED;
        }
        LinkedHashMap<NStoreType, String> storeLocations = new LinkedHashMap<NStoreType, String>();
        if (baseLocations != null) {
            for (Map.Entry<NStoreType, String> e : baseLocations.entrySet()) {
                NStoreType loc = e.getKey();
                if (loc == null) {
                    throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofPlain(NI18n.of("null location")));
                }
                storeLocations.put(loc, e.getValue());
            }
        }
        for (NStoreType location : NStoreType.values()) {
            String c;
            String _storeLocation = (String)storeLocations.get(location);
            if (NBlankable.isBlank(_storeLocation)) {
                switch (storeStrategy) {
                    case STANDALONE: {
                        c = this.getCustomPlatformHomeFolder(location, homeLocations);
                        storeLocations.put(location, c == null ? workspaceLocation + File.separator + location.id() : c);
                        break;
                    }
                    case EXPLODED: {
                        storeLocations.put(location, homes[location.ordinal()]);
                    }
                }
                continue;
            }
            if (!Paths.get(_storeLocation, new String[0]).isAbsolute()) {
                switch (storeStrategy) {
                    case STANDALONE: {
                        c = this.getCustomPlatformHomeFolder(location, homeLocations);
                        storeLocations.put(location, c == null ? workspaceLocation + File.separator + location.id() + NApiUtilsRPI.getNativePath("/" + _storeLocation) : c + NApiUtilsRPI.getNativePath("/" + _storeLocation));
                        break;
                    }
                    case EXPLODED: {
                        storeLocations.put(location, homes[location.ordinal()] + NApiUtilsRPI.getNativePath("/" + _storeLocation));
                    }
                }
                continue;
            }
            storeLocations.put(location, _storeLocation);
        }
        return storeLocations;
    }
}

