/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NOptional;

public class NHomeLocation
implements NEnum {
    private static final Map<String, NHomeLocation> CACHE = new HashMap<String, NHomeLocation>();
    private final NOsFamily osFamily;
    private final NStoreType storeLocation;

    private NHomeLocation(NOsFamily osFamily, NStoreType storeLocation) {
        this.osFamily = osFamily;
        this.storeLocation = storeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NHomeLocation of(NOsFamily osFamily, NStoreType storeLocation) {
        String key = (osFamily == null ? "system" : osFamily.id()) + "_" + (storeLocation == null ? "system" : storeLocation.id());
        NHomeLocation instance = CACHE.get(key);
        if (instance == null) {
            Map<String, NHomeLocation> map = CACHE;
            synchronized (map) {
                instance = CACHE.get(key);
                if (instance == null) {
                    instance = new NHomeLocation(osFamily, storeLocation);
                    CACHE.put(key, instance);
                }
            }
        }
        return instance;
    }

    public static NOptional<NHomeLocation> parse(String value) {
        if ((value = value == null ? "" : value.trim().toLowerCase()).isEmpty()) {
            return NOptional.ofEmpty(() -> NMsg.ofC(NI18n.of("%s is empty"), NHomeLocation.class.getSimpleName()));
        }
        String e = value.replace(':', '_').replace('-', '_');
        String finalValue = value;
        int i = e.lastIndexOf(95);
        if (i >= 0) {
            NStoreType loc;
            String s1 = e.substring(0, i);
            String s2 = e.substring(i + 1);
            NOsFamily osf = s1.equals("system") ? null : NOsFamily.parse(s1).orNull();
            NStoreType nStoreType = loc = s2.equals("system") ? null : NStoreType.parse(s2).orNull();
            if (osf == null && !s1.equals("system") && !s1.isEmpty()) {
                return NOptional.ofError(() -> NMsg.ofC(NI18n.of("%s invalid value : %s"), NHomeLocation.class.getSimpleName(), finalValue));
            }
            if (loc == null && !s2.equals("system") && !s2.isEmpty()) {
                return NOptional.ofError(() -> NMsg.ofC(NI18n.of("%s invalid value : %s"), NHomeLocation.class.getSimpleName(), finalValue));
            }
            return NOptional.of(NHomeLocation.of(osf, loc));
        }
        return NOptional.ofError(() -> NMsg.ofC(NI18n.of("%s invalid value : %s"), NHomeLocation.class.getSimpleName(), finalValue));
    }

    public NOsFamily getOsFamily() {
        return this.osFamily;
    }

    public NStoreType getStoreLocation() {
        return this.storeLocation;
    }

    public int hashCode() {
        return Objects.hash(this.osFamily, this.storeLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NHomeLocation that = (NHomeLocation)o;
        return this.osFamily == that.osFamily && this.storeLocation == that.storeLocation;
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return (this.osFamily == null ? "SYSTEM" : this.osFamily.name()) + "_" + (this.storeLocation == null ? "SYSTEM" : this.storeLocation.name());
    }

    @Override
    public String id() {
        return (this.osFamily == null ? "system" : this.osFamily.id()) + "-" + (this.storeLocation == null ? "system" : this.storeLocation.id());
    }
}

