/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NDesktopEnvironmentFamily implements NEnum
{
    HEADLESS,
    WINDOWS_SHELL,
    MACOS_AQUA,
    KDE,
    GNOME,
    LXDE,
    LXQT,
    XFCE,
    MATE,
    CDE,
    OPENBOX,
    LUMINA,
    UNITY,
    UBUNTU,
    PANTHEON,
    CINNAMON,
    DEEPIN,
    BUDGIE,
    ENLIGHTENMENT,
    AWESOME,
    I3,
    UNKNOWN,
    NONE;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NDesktopEnvironmentFamily> parse(String value) {
        return NEnumUtils.parseEnum(value, NDesktopEnvironmentFamily.class, s -> {
            switch (s.getNormalizedValue()) {
                case "WIN": 
                case "WINDOWS": 
                case "WINDOWSSHELL": {
                    return NOptional.of(WINDOWS_SHELL);
                }
                case "MAC": 
                case "MACOS": 
                case "MACAQUA": 
                case "MACOSAQUA": 
                case "AQUA": {
                    return NOptional.of(MACOS_AQUA);
                }
                case "KDE": 
                case "PLASMA": {
                    return NOptional.of(KDE);
                }
                case "GNOME": {
                    return NOptional.of(GNOME);
                }
                case "UNKNOWN": {
                    return NOptional.of(UNKNOWN);
                }
            }
            return null;
        });
    }

    @Override
    public String id() {
        return this.id;
    }
}

