/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.net;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NHttpCode {
    private static final Map<Integer, NHttpCode> cache = new HashMap<Integer, NHttpCode>();
    public static final NHttpCode OK = NHttpCode.of(200);
    public static final NHttpCode CREATED = NHttpCode.of(201);
    public static final NHttpCode ACCEPTED = NHttpCode.of(202);
    public static final NHttpCode NON_AUTHORITATIVE_INFORMATION = NHttpCode.of(203);
    public static final NHttpCode NO_CONTENT = NHttpCode.of(204);
    public static final NHttpCode RESET_CONTENT = NHttpCode.of(205);
    public static final NHttpCode BAD_REQUEST = NHttpCode.of(400);
    public static final NHttpCode UNAUTHORIZED = NHttpCode.of(401);
    public static final NHttpCode PAYMENT_REQUIRED = NHttpCode.of(402);
    public static final NHttpCode FORBIDDEN = NHttpCode.of(403);
    public static final NHttpCode NOT_FOUND = NHttpCode.of(404);
    public static final NHttpCode METHOD_NOT_ALLOWED = NHttpCode.of(405);
    public static final NHttpCode METHOD_NOT_ACCEPTABLE = NHttpCode.of(406);
    public static final NHttpCode PROXY_AUTHENTICATION_REQUIRED = NHttpCode.of(407);
    public static final NHttpCode REQUEST_TIMEOUT = NHttpCode.of(408);
    public static final NHttpCode CONFLICT = NHttpCode.of(409);
    public static final NHttpCode GONE = NHttpCode.of(410);
    public static final NHttpCode LENGTH_REQUIRED = NHttpCode.of(411);
    public static final NHttpCode PRECONDITION_FAILED = NHttpCode.of(412);
    public static final NHttpCode CONTENT_TOO_LARGE = NHttpCode.of(413);
    public static final NHttpCode URI_TOO_LONG = NHttpCode.of(414);
    public static final NHttpCode UNSUPPORTED_MEDIA_TYPE = NHttpCode.of(415);
    public static final NHttpCode INTERNAL_SERVER_ERROR = NHttpCode.of(500);
    private int code;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NHttpCode of(int code) {
        Map<Integer, NHttpCode> map = cache;
        synchronized (map) {
            if (code >= 0 && code < 600) {
                return cache.computeIfAbsent(code, integer -> new NHttpCode(code));
            }
        }
        return new NHttpCode(code);
    }

    private NHttpCode(int code) {
        this.code = code;
    }

    public boolean isOk() {
        return this.code == NHttpCode.OK.code || this.code >= 200 && this.code < 300;
    }

    public boolean isClientError() {
        return this.code >= 400 && this.code < 500;
    }

    public boolean isServerError() {
        return this.code >= 500;
    }

    public int getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NHttpCode httpCode = (NHttpCode)o;
        return this.code == httpCode.code;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public String toString() {
        return "HTTP" + this.code;
    }
}

