/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.math;

import java.io.Serializable;
import java.util.Objects;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class NFloatComplex
extends Number
implements Serializable,
Comparable<NFloatComplex> {
    public static final NFloatComplex ZERO = new NFloatComplex(0.0f, 0.0f);
    public static final NFloatComplex ONE = new NFloatComplex(1.0f, 0.0f);
    public static final NFloatComplex I = new NFloatComplex(0.0f, 1.0f);
    private float real;
    private float imag;

    public NOptional<NFloatComplex> of(String any) {
        try {
            if (NBlankable.isBlank(any)) {
                return NOptional.ofNamedEmpty("complex");
            }
            any = any.trim();
            String[] c = NReservedUtils.parseComplexStrings(any);
            return NOptional.of(new NFloatComplex(Float.parseFloat(c[0]), Float.parseFloat(c[1])));
        }
        catch (Exception e) {
            return NOptional.ofNamedError("complex : " + any);
        }
    }

    public NFloatComplex(float real, float imag) {
        this.real = real;
        this.imag = imag;
    }

    public float real() {
        return this.real;
    }

    public float imag() {
        return this.imag;
    }

    public float abs() {
        return (float)Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    @Override
    public double doubleValue() {
        return this.real;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NFloatComplex ndComplex = (NFloatComplex)o;
        return Float.compare(this.real, ndComplex.real) == 0 && Float.compare(this.imag, ndComplex.imag) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.real), Float.valueOf(this.imag));
    }

    public String toString() {
        if (this.imag == 0.0f) {
            return this.realToString(this.real);
        }
        if (this.real == 0.0f) {
            return this.imagToString(this.imag);
        }
        if (this.imag < 0.0f) {
            return this.realToString(this.real) + this.imagToString(this.imag);
        }
        return this.realToString(this.real) + "+" + this.imagToString(this.imag);
    }

    protected String realToString(float d) {
        return String.valueOf(d);
    }

    protected String imagToString(float d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d + "*\u00ee";
        }
        if (d == 1.0f) {
            return "\u00ee";
        }
        if (d == -1.0f) {
            return "-\u00ee";
        }
        return d + "\u00ee";
    }

    @Override
    public int compareTo(NFloatComplex other) {
        boolean otherNaN;
        boolean thisNaN = Float.isNaN(this.real) || Float.isNaN(this.imag);
        boolean bl = otherNaN = Float.isNaN(other.real) || Float.isNaN(other.imag);
        if (thisNaN && otherNaN) {
            return 0;
        }
        if (thisNaN) {
            return 1;
        }
        if (otherNaN) {
            return -1;
        }
        float mag1 = this.real * this.real + this.imag * this.imag;
        float mag2 = other.real * other.real + other.imag * other.imag;
        if (mag1 < mag2) {
            return -1;
        }
        if (mag1 > mag2) {
            return 1;
        }
        int cmpReal = Float.compare(this.real, other.real);
        if (cmpReal != 0) {
            return cmpReal;
        }
        return Float.compare(this.imag, other.imag);
    }

    public NFloatComplex add(NFloatComplex other) {
        return new NFloatComplex(this.real + other.real, this.imag + other.imag);
    }

    public NFloatComplex negate() {
        return new NFloatComplex(-this.real, -this.imag);
    }

    public NFloatComplex subtract(NFloatComplex other) {
        return new NFloatComplex(this.real - other.real, this.imag - other.imag);
    }

    public NFloatComplex multiply(NFloatComplex z2) {
        float real = this.real * z2.real - this.imag * z2.imag;
        float imag = this.real * z2.imag + this.imag * z2.real;
        return new NFloatComplex(real, imag);
    }

    public NFloatComplex divide(NFloatComplex other) {
        float c = other.real;
        float d = other.imag;
        float denominator = c * c + d * d;
        return new NFloatComplex((this.real * c + this.imag * d) / denominator, (this.imag * c - this.real * d) / denominator);
    }

    public NFloatComplex inv() {
        float denominator = this.real * this.real + this.imag * this.imag;
        return new NFloatComplex(this.real / denominator, -this.imag / denominator);
    }
}

