/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.math;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NNumberUtils;
import net.thevpc.nuts.util.NOptional;

public class NBigComplex
extends Number
implements Serializable,
Comparable<NBigComplex> {
    private static final BigDecimal BIG_DECIMAL_MINUS_ONE = new BigDecimal("-1");
    public static final NBigComplex ZERO = new NBigComplex(BigDecimal.ZERO, BigDecimal.ZERO);
    public static final NBigComplex ONE = new NBigComplex(BigDecimal.ONE, BigDecimal.ZERO);
    public static final NBigComplex I = new NBigComplex(BigDecimal.ZERO, BigDecimal.ONE);
    private BigDecimal real;
    private BigDecimal imag;

    public NOptional<NBigComplex> of(String any) {
        try {
            if (NBlankable.isBlank(any)) {
                return NOptional.ofNamedEmpty("complex");
            }
            any = any.trim();
            String[] c = NReservedUtils.parseComplexStrings(any);
            return NOptional.of(new NBigComplex(new BigDecimal(c[0]), new BigDecimal(c[1])));
        }
        catch (Exception e) {
            return NOptional.ofNamedError("complex : " + any);
        }
    }

    public NBigComplex(BigDecimal real, BigDecimal imag) {
        this.real = NAssert.requireNonNull(real, "real");
        this.imag = NAssert.requireNonNull(imag, "imag");
    }

    public BigDecimal real() {
        return this.real;
    }

    public BigDecimal imag() {
        return this.imag;
    }

    @Override
    public double doubleValue() {
        return this.real().doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBigComplex ndComplex = (NBigComplex)o;
        return this.real.compareTo(ndComplex.real) == 0 && this.imag.compareTo(ndComplex.imag) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.real, this.imag);
    }

    public String toString() {
        if (this.imag.equals(BigDecimal.ZERO)) {
            return this.realToString(this.real);
        }
        if (this.real.equals(BigDecimal.ZERO)) {
            return this.imagToString(this.imag);
        }
        if (this.imag.compareTo(BigDecimal.ZERO) < 0) {
            return this.realToString(this.real) + this.imagToString(this.imag);
        }
        return this.realToString(this.real) + "+" + this.imagToString(this.imag);
    }

    protected String realToString(BigDecimal d) {
        return String.valueOf(d);
    }

    protected String imagToString(BigDecimal d) {
        if (d.equals(BigDecimal.ONE)) {
            return "\u00ee";
        }
        if (d.equals(BIG_DECIMAL_MINUS_ONE)) {
            return "-\u00ee";
        }
        return d + "\u00ee";
    }

    @Override
    public int compareTo(NBigComplex other) {
        BigDecimal mag2;
        BigDecimal mag1 = this.real.multiply(this.real).add(this.imag.multiply(this.imag));
        int cmp = mag1.compareTo(mag2 = other.real.multiply(other.real).add(other.imag.multiply(other.imag)));
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.real.compareTo(other.real);
        if (cmp != 0) {
            return cmp;
        }
        return this.imag.compareTo(other.imag);
    }

    public NBigComplex add(NBigComplex other) {
        return new NBigComplex(this.real.add(other.real), this.imag.add(other.imag));
    }

    public NBigComplex negate() {
        return new NBigComplex(this.real.negate(), this.imag.negate());
    }

    public NBigComplex subtract(NBigComplex other) {
        return new NBigComplex(this.real.subtract(other.real), this.imag.subtract(other.imag));
    }

    public NBigComplex multiply(NBigComplex z2, MathContext mc) {
        BigDecimal a = this.real;
        BigDecimal b = this.imag;
        BigDecimal c = z2.real;
        BigDecimal d = z2.imag;
        mc = NNumberUtils.getContextMathContext(mc);
        BigDecimal p1 = a.multiply(c, mc);
        BigDecimal p2 = b.multiply(d, mc);
        BigDecimal p3 = a.add(b, mc).multiply(c.add(d, mc), mc);
        BigDecimal real = p1.subtract(p2, mc);
        BigDecimal imag = p3.subtract(p1, mc).subtract(p2, mc);
        return new NBigComplex(real, imag);
    }

    public NBigComplex divide(NBigComplex other, MathContext mc) {
        mc = NNumberUtils.getContextMathContext(mc);
        BigDecimal c = other.real;
        BigDecimal d = other.imag;
        BigDecimal denominator = c.multiply(c, mc).add(d.multiply(d, mc), mc);
        if (denominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero complex number.");
        }
        BigDecimal real = this.real.multiply(c, mc).add(this.imag.multiply(d, mc), mc).divide(denominator, mc);
        BigDecimal imag = this.imag.multiply(c, mc).subtract(this.real.multiply(d, mc), mc).divide(denominator, mc);
        return new NBigComplex(real, imag);
    }

    public NBigComplex inv(MathContext mc) {
        BigDecimal denominator = this.real.multiply(this.real, mc = NNumberUtils.getContextMathContext(mc)).add(this.imag.multiply(this.imag, mc), mc);
        if (denominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Inverse of zero complex number is undefined.");
        }
        return new NBigComplex(this.real.divide(denominator, mc), this.imag.negate().divide(denominator, mc));
    }
}

