/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.log;

import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NLogSPI;
import net.thevpc.nuts.log.NLogs;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgSupplier;
import net.thevpc.nuts.util.NBlankable;

public interface NLogContext
extends NBlankable {
    public static NLogContext ofPlaceholder(String name, Object value) {
        return NLogs.of().newContext().withPlaceholder(name, value);
    }

    public static NLogContext ofMessagePrefix(NMsg prefix) {
        return NLogs.of().newContext().withMessagePrefix(prefix);
    }

    public static NLogContext ofMessageSuffix(NMsg suffix) {
        return NLogs.of().newContext().withMessageSuffix(suffix);
    }

    public static NLogContext ofPlaceholderSuppliers(Map<String, Supplier<?>> properties) {
        return NLogs.of().newContext().withPlaceholderSuppliers(properties);
    }

    public static NLogContext ofPlaceholders(Map<String, ?> properties) {
        return NLogs.of().newContext().withPlaceholders(properties);
    }

    public static NLogContext ofLog(Class<?> log) {
        return NLogs.of().newContext().withLog(log == null ? null : NLog.of(log));
    }

    public static NLogContext ofLog(String log) {
        return NLogs.of().newContext().withLog(log == null ? null : NLog.of(log));
    }

    public static NLogContext ofLog(NLog log) {
        return NLogs.of().newContext().withLog(log);
    }

    public static NLogContext ofLog(NLogSPI log) {
        return NLogs.of().newContext().withLog(log);
    }

    public static NLogContext ofLog(String name, NLogSPI log) {
        return NLogs.of().newContext().withLog(name, log);
    }

    public static NLogContext of() {
        return NLogs.of().newContext();
    }

    public Map<String, Supplier<?>> getPlaceholders();

    public Object getPlaceholder(String var1);

    public NLogContext withMessagePrefix(NMsg var1);

    public NLogContext withMessagePrefix(NMsgSupplier<NMsg> var1);

    public NLogContext withMessageSuffix(NMsgSupplier<NMsg> var1);

    public NLogContext withMessageSuffix(NMsg var1);

    public NLogContext withPlaceholders(Map<String, ?> var1);

    public NLogContext withPlaceholderSuppliers(Map<String, Supplier<?>> var1);

    public NLogContext withPlaceholder(String var1, Object var2);

    public NLogContext withPlaceholderSupplier(String var1, Supplier<?> var2);

    public NLogContext withLog(NLog var1);

    public NLogContext withLog(NLogSPI var1);

    public NLogContext withLog(String var1, NLogSPI var2);

    public NLogContext mergedWith(NLogContext var1);

    public NMsgSupplier<NMsg> getMessagePrefix();

    public NMsgSupplier<NMsg> getMessageSuffix();

    public NLog getLog();

    @Override
    public boolean isBlank();
}

