/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final String charsetName;
    private byte[] buffer;
    private int index;
    private int end;

    public ReaderInputStream(Reader reader, String charsetName) {
        this.reader = reader;
        this.charsetName = charsetName == null ? "UTF-8" : charsetName;
        this.buffer = null;
        this.index = 0;
        this.end = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.end) {
            char[] charBuffer = new char[1024];
            int numChars = this.reader.read(charBuffer);
            if (numChars == -1) {
                return -1;
            }
            this.buffer = new String(charBuffer, 0, numChars).getBytes(this.charsetName);
            this.index = 0;
            this.end = this.buffer.length;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

