/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NTerminalMode implements NEnum
{
    DEFAULT,
    INHERITED,
    ANSI,
    FORMATTED,
    FILTERED;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NTerminalMode> parse(String value) {
        return NEnumUtils.parseEnum(value, NTerminalMode.class, s -> {
            String normalizedValue;
            switch (normalizedValue = s.getNormalizedValue()) {
                case "SYSTEM": 
                case "S": 
                case "AUTO": 
                case "D": 
                case "DEFAULT": {
                    return NOptional.of(DEFAULT);
                }
                case "INHERITED": 
                case "H": {
                    return NOptional.of(INHERITED);
                }
                case "A": 
                case "ANSI": {
                    return NOptional.of(ANSI);
                }
                case "TRUE": 
                case "YES": 
                case "Y": 
                case "SUPPORTED": 
                case "ALWAYS": 
                case "FORMATTED": {
                    return NOptional.of(FORMATTED);
                }
                case "NO": 
                case "FALSE": 
                case "NEVER": 
                case "UNSUPPORTED": 
                case "FILTERED": {
                    return NOptional.of(FILTERED);
                }
            }
            Boolean b = NLiteral.of(normalizedValue).asBoolean().orNull();
            if (b != null) {
                return NOptional.of(b != false ? FORMATTED : FILTERED);
            }
            return null;
        });
    }

    @Override
    public String id() {
        return this.id;
    }
}

