/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.util.Objects;
import net.thevpc.nuts.io.NPathExtensionType;

public class NPathRenameOptions {
    private final String template;
    private final String extension;
    private final NPathExtensionType type;

    private NPathRenameOptions(String template, String extension, NPathExtensionType type) {
        this.template = template;
        this.extension = extension;
        this.type = type;
    }

    public static NPathRenameOptions ofExtension(String ext) {
        return new NPathRenameOptions(null, ext, NPathExtensionType.SMART);
    }

    public static NPathRenameOptions ofTemplate(String template) {
        return new NPathRenameOptions(template, null, NPathExtensionType.SMART);
    }

    public NPathRenameOptions withSmartExtension() {
        return new NPathRenameOptions(this.template, this.extension, NPathExtensionType.SMART);
    }

    public NPathRenameOptions withLongExtension() {
        return new NPathRenameOptions(this.template, this.extension, NPathExtensionType.LONG);
    }

    public NPathRenameOptions withShortExtension() {
        return new NPathRenameOptions(this.template, this.extension, NPathExtensionType.SHORT);
    }

    public String template() {
        return this.template;
    }

    public String extension() {
        return this.extension;
    }

    public NPathExtensionType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPathRenameOptions that = (NPathRenameOptions)o;
        return Objects.equals(this.template, that.template) && Objects.equals(this.extension, that.extension) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.template, this.extension, this.type);
    }

    public String toString() {
        return "NPathRenameOptions{template='" + this.template + '\'' + ", extension='" + this.extension + '\'' + ", type=" + this.type + '}';
    }
}

