/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.util.Objects;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NPathNameParts {
    private String baseName;
    private String extension;
    private String fullExtension;
    private NPathExtensionType type;

    public static NPathNameParts ofLong(String baseName, String extension, String fullExtension) {
        return new NPathNameParts(baseName, extension, fullExtension, NPathExtensionType.LONG);
    }

    public static NPathNameParts ofShort(String baseName, String extension, String fullExtension) {
        return new NPathNameParts(baseName, extension, fullExtension, NPathExtensionType.SHORT);
    }

    public static NPathNameParts ofSmart(String baseName, String extension, String fullExtension) {
        return new NPathNameParts(baseName, extension, fullExtension, NPathExtensionType.SMART);
    }

    public static NPathNameParts ofLong(String baseName, String extension) {
        return new NPathNameParts(baseName, extension, extension == null ? "" : "." + extension, NPathExtensionType.LONG);
    }

    public static NPathNameParts ofShort(String baseName, String extension) {
        return new NPathNameParts(baseName, extension, extension == null ? "" : "." + extension, NPathExtensionType.SHORT);
    }

    public static NPathNameParts ofSmart(String baseName, String extension) {
        return new NPathNameParts(baseName, extension, extension == null ? "" : "." + extension, NPathExtensionType.SMART);
    }

    public NPathNameParts(String baseName, String extension, String fullExtension, NPathExtensionType type) {
        this.baseName = baseName == null ? "" : baseName;
        this.extension = extension == null ? "" : extension;
        this.fullExtension = fullExtension == null ? "" : fullExtension;
        this.type = type == null ? NPathExtensionType.SHORT : type;
    }

    public NPathExtensionType getType() {
        return this.type;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFullExtension() {
        return this.fullExtension;
    }

    public String toName() {
        return this.baseName + this.fullExtension;
    }

    public String toName(String template) {
        return NMsg.ofV(template, s -> {
            switch (NStringUtils.trim(s).toLowerCase()) {
                case "name": {
                    return this.toName();
                }
                case "base": 
                case "basename": 
                case "base-name": {
                    return this.getBaseName();
                }
                case "ext": 
                case "extension": {
                    return this.getExtension();
                }
                case "fullext": 
                case "full-ext": 
                case "full-extension": 
                case "fullextension": {
                    return this.getFullExtension();
                }
            }
            return null;
        }).toString();
    }

    public String toNameWithExtension(String extension) {
        if (NBlankable.isBlank(extension)) {
            return this.baseName;
        }
        if (!(extension = extension.trim()).startsWith(".")) {
            extension = "." + extension;
        }
        return this.baseName + extension;
    }

    public String toString() {
        return "NPathNameParts{baseName='" + this.baseName + '\'' + ", extension='" + this.extension + '\'' + ", fullExtension='" + this.fullExtension + '\'' + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPathNameParts that = (NPathNameParts)o;
        return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.extension, that.extension) && Objects.equals(this.fullExtension, that.fullExtension) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.baseName, this.extension, this.fullExtension, this.type);
    }
}

