/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputStreamProvider;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPathChildDigestInfo;
import net.thevpc.nuts.io.NPathChildStringDigestInfo;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.io.NPathInfo;
import net.thevpc.nuts.io.NPathNameParts;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathRenameOptions;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;

public interface NPath
extends NInputSource,
NOutputTarget,
Comparable<NPath> {
    public static NPath of(URL path) {
        return NIO.of().createPath(path);
    }

    public static NPath of(NConnectionString path) {
        return NIO.of().createPath(path == null ? null : path.toString());
    }

    public static NPath of(String path, ClassLoader classLoader) {
        return NIO.of().createPath(path, classLoader);
    }

    public static NPath of(File path) {
        return NIO.of().createPath(path);
    }

    public static NPath of(Path path) {
        return NIO.of().createPath(path);
    }

    public static NPath of(String path) {
        return NIO.of().createPath(path);
    }

    public static NPath of(NPathSPI path) {
        return NIO.of().createPath(path);
    }

    public static NPath ofUserHome() {
        return NPath.of(Paths.get(System.getProperty("user.home"), new String[0]));
    }

    public static NPath ofIdStore(NId id, NStoreType storeType) {
        NAssert.requireNonBlank(id, "id");
        NAssert.requireNonBlank(storeType, "storeType");
        return NWorkspace.of().getStoreLocation(id, storeType);
    }

    public static NPath ofWorkspaceStore(NStoreType storeType) {
        NAssert.requireNonBlank(storeType, "storeType");
        return NWorkspace.of().getStoreLocation(storeType);
    }

    public static NPath ofStore(NLocationKey locationKey) {
        NAssert.requireNonBlank(locationKey, "locationKey");
        return NWorkspace.of().getStoreLocation(locationKey);
    }

    public static NPath ofUserStore(NStoreType storeType) {
        NAssert.requireNonBlank(storeType, "storeType");
        return NPath.of(NBootPlatformHome.of(null).getStore(storeType.id()));
    }

    public static NPath ofSystemStore(NStoreType storeType) {
        NAssert.requireNonBlank(storeType, "storeType");
        return NPath.of(NBootPlatformHome.ofSystem(null).getStore(storeType.id()));
    }

    public static NPath ofUserDirectory() {
        return NPath.of(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public static NPath ofTempFile(String name) {
        return NIO.of().ofTempFile(name);
    }

    public static NPath ofTempFile() {
        return NIO.of().ofTempFile();
    }

    public static NPath ofTempFolder(String name) {
        return NIO.of().ofTempFolder(name);
    }

    public static NPath ofTempFolder() {
        return NIO.of().ofTempFolder();
    }

    public static NPath ofTempRepositoryFile(String name, NRepository repository) {
        return NIO.of().ofTempRepositoryFile(name, repository);
    }

    public static NPath ofTempRepositoryFile(NRepository repository) {
        return NIO.of().ofTempRepositoryFile(repository);
    }

    public static NPath ofTempRepositoryFolder(String name, NRepository repository) {
        return NIO.of().ofTempRepositoryFolder(name, repository);
    }

    public static NPath ofTempRepositoryFolder(NRepository repository) {
        return NIO.of().ofTempRepositoryFolder(repository);
    }

    public static NPath ofTempIdFile(String name, NId id) {
        return NIO.of().ofTempIdFile(name, id);
    }

    public static NPath ofTempIdFile(NId id) {
        return NIO.of().ofTempIdFile(id);
    }

    public static NPath ofTempIdFolder(String name, NId id) {
        return NIO.of().ofTempIdFolder(name, id);
    }

    public static NPath ofTempIdFolder(NId id) {
        return NIO.of().ofTempIdFolder(id);
    }

    public String contentEncoding();

    @Override
    public String getContentType();

    public boolean isUserCache();

    public NPath setUserCache(boolean var1);

    public boolean isUserTemporary();

    public NPath setUserTemporary(boolean var1);

    public NPath resolveSibling(NPathRenameOptions var1);

    public NPathNameParts nameParts();

    public NPathNameParts nameParts(NPathExtensionType var1);

    @Override
    public String getName();

    public String getLocation();

    public NPath resolve(String var1);

    public NPath resolveChild(String var1);

    public NPath resolveChild(NPath var1);

    public NPath resolve(NPath var1);

    public NPath resolveSibling(String var1);

    public NPath resolveSibling(NPath var1);

    public byte[] readBytes(NPathOption ... var1);

    public String readString(NPathOption ... var1);

    public String readString(Charset var1, NPathOption ... var2);

    public NPath writeBytes(byte[] var1, NPathOption ... var2);

    public NPath writeString(String var1, Charset var2, NPathOption ... var3);

    public NPath writeString(String var1, NPathOption ... var2);

    default public NPath writeObject(Object any, NPathOption ... options) {
        try (NPrintStream out = this.getNPrintStream(options);){
            out.print(any);
        }
        return this;
    }

    default public NPath writeMsg(NMsg any, NPathOption ... options) {
        try (NPrintStream out = this.getNPrintStream(options);){
            out.print(any);
        }
        return this;
    }

    default public NPath writeText(NText any, NPathOption ... options) {
        try (NPrintStream out = this.getNPrintStream(options);){
            out.print(any);
        }
        return this;
    }

    public String getProtocol();

    public NPath toCompressedForm();

    public NOptional<URL> toURL();

    public boolean isURL();

    public boolean isFile();

    public NOptional<Path> toPath();

    public NOptional<File> toFile();

    public String toString();

    public NStream<NPath> stream();

    public List<NPath> list();

    public List<NPathInfo> listInfos();

    public InputStream getInputStream(NPathOption ... var1);

    public PrintStream getPrintStream();

    public PrintStream getPrintStream(Charset var1, NPathOption ... var2);

    public PrintStream getPrintStream(NPathOption ... var1);

    public NPrintStream getNPrintStream(NPathOption ... var1);

    public OutputStream getOutputStream(NPathOption ... var1);

    public Reader getReader(NPathOption ... var1);

    public BufferedReader getBufferedReader(NPathOption ... var1);

    public BufferedReader getBufferedReader(Charset var1, NPathOption ... var2);

    public Reader getReader(Charset var1, NPathOption ... var2);

    public Writer getWriter();

    public Writer getWriter(NPathOption ... var1);

    public Writer getWriter(Charset var1, NPathOption ... var2);

    public BufferedWriter getBufferedWriter();

    public BufferedWriter getBufferedWriter(NPathOption ... var1);

    public BufferedWriter getBufferedWriter(Charset var1, NPathOption ... var2);

    public NPath delete();

    public NPath deleteTree();

    public NPath ensureEmptyDirectory();

    public NPath ensureEmptyFile();

    public NPath delete(boolean var1);

    public NPath mkdir(boolean var1);

    public NPath mkdirs();

    public NPath mkdir();

    public NPath expandPath(Function<String, String> var1);

    public NPath mkParentDirs();

    public boolean isOther();

    public boolean isSymbolicLink();

    public NPathType type();

    public boolean isDirectory();

    public boolean isRegularFile();

    public boolean isRemote();

    public boolean isLocal();

    public boolean exists();

    @Override
    public long getContentLength();

    public Instant getLastModifiedInstant();

    public Instant getLastAccessInstant();

    public Instant getCreationInstant();

    public NPath getParent();

    public boolean isAbsolute();

    public NPath normalize();

    public NPath toAbsolute();

    public NPath toAbsolute(String var1);

    public NPath toAbsolute(NPath var1);

    public NOptional<String> toRelative(NPath var1);

    public String owner();

    public String group();

    public Set<NPathPermission> getPermissions();

    public NPath setPermissions(NPathPermission ... var1);

    public NPath addPermissions(NPathPermission ... var1);

    public NPath removePermissions(NPathPermission ... var1);

    public boolean isName();

    public boolean isRoot();

    public NStream<NPath> walk(int var1, NPathOption[] var2);

    public NStream<NPath> walk(NPathOption ... var1);

    public NStream<NPath> walk(int var1);

    public NStream<NPath> walk();

    public NPath subpath(int var1, int var2);

    public String getName(int var1);

    public List<String> getNames();

    public void moveTo(NPath var1, NPathOption ... var2);

    public void copyTo(NPath var1, NPathOption ... var2);

    public void copyFrom(NPath var1, NPathOption ... var2);

    public void copyFromInputStream(InputStream var1, NPathOption ... var2);

    public void copyFromInputStreamProvider(NInputStreamProvider var1, NPathOption ... var2);

    public void copyFromReader(Reader var1, NPathOption ... var2);

    public void copyFromReader(Reader var1, Charset var2, NPathOption ... var3);

    public void copyToOutputStream(OutputStream var1, NPathOption ... var2);

    public void copyToPrintStream(PrintStream var1, NPathOption ... var2);

    public void copyToPrintStream(PrintStream var1, Charset var2, NPathOption ... var3);

    public void copyToWriter(Writer var1, NPathOption ... var2);

    public void copyToWriter(Writer var1, Charset var2, NPathOption ... var3);

    public NPath getRoot();

    public NPath walkDfs(NTreeVisitor<NPath> var1, NPathOption ... var2);

    public NPath walkDfs(NTreeVisitor<NPath> var1, int var2, NPathOption ... var3);

    public NStream<NPath> walkGlob(NPathOption ... var1);

    public boolean isHttp();

    public NPath copy();

    public void setDeleteOnDispose(boolean var1);

    public boolean isDeleteOnDispose();

    public boolean isEqOrDeepChildOf(NPath var1);

    public boolean startsWith(NPath var1);

    public boolean startsWith(String var1);

    public int getNameCount();

    @Override
    public int compareTo(NPath var1);

    public List<NPathChildDigestInfo> listDigestInfo();

    public List<NPathChildDigestInfo> listDigestInfo(String var1);

    public List<NPathChildStringDigestInfo> listStringDigestInfo();

    public List<NPathChildStringDigestInfo> listStringDigestInfo(String var1);

    public NPathInfo getInfo();
}

