/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class NCharReader
extends BufferedReader {
    public NCharReader(Reader reader) {
        super(reader);
    }

    public String read(int count) throws IOException {
        char[] c = new char[count];
        int v = this.read(c);
        return new String(c, 0, v);
    }

    public boolean canRead() throws IOException {
        return this.peek(1).length() > 0;
    }

    public boolean canReadByCount(int count) throws IOException {
        return this.peek(count).length() > count;
    }

    @Override
    public int read(char[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        int read;
        int v;
        for (read = 0; read < count && (v = super.read(buffer, offset, count)) > 0; read += v, count -= v) {
            offset += v;
        }
        return read;
    }

    public boolean read(String text) throws IOException {
        if (text == null || text.isEmpty()) {
            return true;
        }
        String s = this.peek(text.length());
        if (s.equals(text)) {
            this.skip(text.length());
            return true;
        }
        return false;
    }

    public boolean peek(String text) throws IOException {
        if (text == null || text.isEmpty()) {
            return true;
        }
        String s = this.peek(text.length());
        return s.equals(text);
    }

    public char readChar() throws IOException {
        int c = this.read();
        if (c < 0) {
            throw new IllegalArgumentException("EOF");
        }
        return (char)c;
    }

    public int peek() throws IOException {
        this.mark(1);
        int s = this.read();
        if (s >= 0) {
            this.reset();
        }
        return s;
    }

    public String peek(int count) throws IOException {
        if (count <= 0) {
            return "";
        }
        this.mark(count);
        String s = this.read(count);
        this.reset();
        return s;
    }
}

