/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.thevpc.nuts.io.NIOUtils;

public class NByteArrayCache
implements Closeable {
    private boolean persisted;
    private int maxSize;
    private OutputStream out;
    private File file;
    private long currSize;

    public NByteArrayCache() {
        this(0xA00000);
    }

    public NByteArrayCache(int maxSize) {
        this.maxSize = maxSize;
    }

    public long size() {
        return this.currSize;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public NByteArrayCache write(byte[] data) {
        try {
            if (this.persisted) {
                this.out.write(data);
                this.currSize += (long)data.length;
            } else {
                if (this.out == null) {
                    this.out = new ByteArrayOutputStream();
                }
                this.out.write(data);
                this.currSize += (long)data.length;
                if (this.currSize > (long)this.maxSize) {
                    if (this.file == null) {
                        this.file = Files.createTempFile("temp", ".temp", new FileAttribute[0]).toFile();
                    }
                    FileOutputStream fos = new FileOutputStream(this.file, true);
                    fos.write(((ByteArrayOutputStream)this.out).toByteArray());
                    this.out = fos;
                    this.persisted = true;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public NByteArrayCache copyTo(OutputStream out) {
        block8: {
            try {
                if (this.out == null) break block8;
                if (!this.persisted) {
                    out.write(((ByteArrayOutputStream)this.out).toByteArray());
                    break block8;
                }
                this.out.close();
                this.out = null;
                try (FileInputStream fis = new FileInputStream(this.file);){
                    NIOUtils.copy((InputStream)fis, out);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

