/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class DefaultNPathMetadata {
    private NPath path;
    private NMsg message;
    private String kind;
    private Long contentLength;
    private String contentType;
    private String charset;
    private String name;
    private boolean userCache;
    private boolean userTemporary;
    private PathMetadata md = new PathMetadata(this);

    public DefaultNPathMetadata(NPath path) {
        this.path = path;
    }

    public NContentMetadata getMetaData() {
        return this.md;
    }

    public boolean isUserCache() {
        return this.userCache;
    }

    public DefaultNPathMetadata setUserCache(boolean userCache) {
        this.userCache = userCache;
        return this;
    }

    public boolean isUserTemporary() {
        return this.userTemporary;
    }

    public DefaultNPathMetadata setUserTemporary(boolean userTemporary) {
        this.userTemporary = userTemporary;
        return this;
    }

    public NOptional<String> getName() {
        if (!NBlankable.isBlank(this.name)) {
            return NOptional.of(this.name);
        }
        String n = this.path.getName();
        if (!NBlankable.isBlank(n)) {
            return NOptional.of(n);
        }
        NMsg m = this.getMessage().orNull();
        if (m != null) {
            return NOptional.of(m.toString());
        }
        return NOptional.ofNamedEmpty("name");
    }

    public NOptional<NMsg> getMessage() {
        return NOptional.ofNamed(this.message, "message").orElseOf(() -> NMsg.ofNtf(NFormats.of(this.path).get().format()));
    }

    public NOptional<String> getKind() {
        return NOptional.ofNamed(this.kind, "kind");
    }

    public NOptional<Long> getContentLength() {
        return NOptional.ofNamed(this.contentLength, "contentLength").orElseOf(() -> this.path.getContentLength());
    }

    public NOptional<String> getContentType() {
        return NOptional.ofNamed(this.contentType, "contentType").orElseOf(() -> this.path.getContentType());
    }

    public NOptional<String> getCharset() {
        return NOptional.ofNamed(this.charset, "charset").orElseOf(() -> this.path.getCharset());
    }

    public void setMessage(NMsg message) {
        this.message = message;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void copyFrom(NContentMetadata cmd) {
        if (cmd == null) {
            return;
        }
        this.message = cmd.getMessage().orNull();
        this.kind = cmd.getKind().orNull();
        this.contentLength = cmd.getContentLength().orNull();
        this.contentType = cmd.getContentType().orNull();
        this.charset = cmd.getCharset().orNull();
        this.name = cmd.getName().orNull();
    }

    public void copyFrom(DefaultNPathMetadata cmd) {
        if (cmd == null) {
            return;
        }
        this.message = cmd.message;
        this.kind = cmd.kind;
        this.contentLength = cmd.contentLength;
        this.contentType = cmd.contentType;
        this.charset = cmd.charset;
        this.name = cmd.name;
        this.userCache = cmd.userCache;
        this.userTemporary = cmd.userTemporary;
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    private class PathMetadata
    implements NContentMetadata {
        private DefaultNPathMetadata outer;

        public PathMetadata(DefaultNPathMetadata outer) {
            this.outer = outer;
        }

        @Override
        public NOptional<String> getName() {
            return this.outer.getName();
        }

        @Override
        public NContentMetadata setName(String name) {
            this.outer.setName(name);
            return this;
        }

        @Override
        public NOptional<String> getKind() {
            return this.outer.getName();
        }

        @Override
        public NContentMetadata setKind(String userKind) {
            this.outer.setKind(userKind);
            return this;
        }

        @Override
        public NContentMetadata setMessage(NMsg message) {
            this.outer.setMessage(message);
            return this;
        }

        @Override
        public NOptional<NMsg> getMessage() {
            return this.outer.getMessage();
        }

        public String toString() {
            return this.outer.toString();
        }

        @Override
        public NOptional<Long> getContentLength() {
            return this.outer.getContentLength();
        }

        @Override
        public NOptional<String> getContentType() {
            return this.outer.getContentType();
        }

        @Override
        public NContentMetadata setContentType(String contentType) {
            this.outer.setContentType(contentType);
            return this;
        }

        @Override
        public NContentMetadata setContentLength(Long contentLength) {
            this.outer.setContentLength(contentLength);
            return this;
        }

        @Override
        public NOptional<String> getCharset() {
            return this.outer.getCharset();
        }

        @Override
        public NContentMetadata setCharset(String charset) {
            this.outer.setCharset(charset);
            return this;
        }

        @Override
        public boolean isBlank() {
            if (this.outer.contentLength != null && this.outer.contentLength >= 0L) {
                return false;
            }
            if (this.outer.message != null) {
                return false;
            }
            if (this.outer.contentType != null) {
                return false;
            }
            if (this.outer.name != null) {
                return false;
            }
            if (this.outer.charset != null) {
                return false;
            }
            return DefaultNPathMetadata.this.kind == null;
        }
    }
}

