/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.io.NPathInfo;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;

public class DefaultNPathInfo
implements NPathInfo {
    private String path;
    private NPathType type;
    private NPathType targetType;
    private String targetPath;
    private long size;
    private boolean symbolicLink;
    private Instant lastModified;
    private Instant creationTime;
    private Instant lastAccess;
    private Set<NPathPermission> permissions;
    private String owner;
    private String group;

    public static DefaultNPathInfo ofNotFound(String path) {
        return new DefaultNPathInfo(path, NPathType.NOT_FOUND, null, null, -1L, false, null, null, null, Collections.emptySet(), null, null);
    }

    public DefaultNPathInfo(String path, NPathType type, NPathType targetType, String targetPath, long size, boolean symbolicLink, Instant lastModified, Instant lastAccess, Instant creationTime, Set<NPathPermission> permissions, String owner, String group) {
        this.path = path;
        this.type = type;
        this.targetType = targetType;
        this.targetPath = targetPath;
        this.size = size;
        this.symbolicLink = symbolicLink;
        this.lastModified = lastModified;
        this.creationTime = creationTime;
        this.lastAccess = lastAccess;
        this.permissions = permissions;
        this.owner = owner;
        this.group = group;
    }

    @Override
    public Instant getLastAccessInstant() {
        return this.lastAccess;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public NPathType getType() {
        return this.type;
    }

    @Override
    public NPathType getTargetType() {
        return this.targetType;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }

    @Override
    public long getContentLength() {
        return this.size;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }

    @Override
    public Instant getLastModifiedInstant() {
        return this.lastModified;
    }

    @Override
    public Instant getCreationInstant() {
        return this.creationTime;
    }

    @Override
    public Set<NPathPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNPathInfo that = (DefaultNPathInfo)o;
        return this.size == that.size && this.symbolicLink == that.symbolicLink && Objects.equals(this.path, that.path) && this.type == that.type && this.targetType == that.targetType && Objects.equals(this.targetPath, that.targetPath) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.owner, that.owner);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.type, this.targetType, this.targetPath, this.size, this.symbolicLink, this.lastModified, this.creationTime, this.permissions, this.owner);
    }

    public String toString() {
        return "DefaultNPathInfo{path='" + this.path + '\'' + ", type=" + this.type + ", targetType=" + this.targetType + ", targetPath='" + this.targetPath + '\'' + ", size=" + this.size + ", symbolicLink=" + this.symbolicLink + ", lastModified=" + this.lastModified + ", creationTime=" + this.creationTime + ", permissions=" + this.permissions + ", owner='" + this.owner + '\'' + '}';
    }
}

