/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class AutoCloseableReader
extends Reader
implements AutoCloseable {
    private Reader base;
    private boolean closed;

    public AutoCloseableReader(Reader base) {
        this.base = base;
    }

    @Override
    public int read(char[] chars, int i, int len) throws IOException {
        int r = this.base.read(chars, i, len);
        if (r == 0 && len > 0) {
            this.close();
        }
        return r;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int r = this.base.read(target);
        if (r == 0 && target.length() > 0) {
            this.close();
        }
        return r;
    }

    @Override
    public int read() throws IOException {
        int r = this.base.read();
        if (r < 0) {
            this.close();
        }
        return r;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int r = this.base.read(cbuf);
        if (r == 0 && cbuf.length > 0) {
            this.close();
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.base.skip(n);
        if (r == 0L && n > 0L) {
            this.close();
        }
        return r;
    }

    @Override
    public boolean ready() throws IOException {
        boolean r = this.base.ready();
        return r;
    }

    @Override
    public boolean markSupported() {
        boolean r = this.base.markSupported();
        return r;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.base.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.base.reset();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.base.close();
            this.closed = true;
        }
    }
}

