/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.IOException;
import java.io.InputStream;

public class AutoCloseableInputStream
extends InputStream
implements AutoCloseable {
    private InputStream base;
    private boolean closed;

    public AutoCloseableInputStream(InputStream base) {
        this.base = base;
    }

    @Override
    public int read() throws IOException {
        int r = this.base.read();
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = super.read(b);
        if (r < 0) {
            this.close();
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (r == 0 && len > 0) {
            this.close();
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = super.skip(n);
        if (r == 0L && n > 0L) {
            this.close();
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.base.close();
            this.closed = true;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.base.reset();
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }
}

