/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.artifact.DefaultNVersionInterval;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public class NReservedVersionIntervalParser {
    final int NEXT = 1;
    final int NEXT_COMMA = 2;
    final int EXPECT_V1 = 3;
    final int EXPECT_V_COMMA = 4;
    final int EXPECT_V2 = 5;
    final int EXPECT_CLOSE = 6;
    int t;
    int state = 1;
    int open = -1;
    int close = -1;
    String v1 = null;
    String v2 = null;
    List<NVersionInterval> dd = new ArrayList<NVersionInterval>();
    NVersionComparator versionComparator;

    public NReservedVersionIntervalParser(NVersionComparator versionComparator) {
        this.versionComparator = versionComparator;
    }

    void reset() {
        this.open = -1;
        this.close = -1;
        this.v1 = null;
        this.v2 = null;
    }

    void addNextValue(String sval) {
        if (sval.endsWith("*")) {
            String min = sval.substring(0, sval.length() - 1);
            if (min.equals("")) {
                this.dd.add(new DefaultNVersionInterval(false, false, min, null, this.versionComparator));
            } else {
                String max = NVersion.of(min).inc(-1).getValue();
                this.dd.add(new DefaultNVersionInterval(true, false, min, max, this.versionComparator));
            }
        } else {
            this.dd.add(new DefaultNVersionInterval(true, true, sval, sval, this.versionComparator));
        }
    }

    void addNextInterval() {
        boolean inclusiveLowerBoundary = this.open == 91 && this.v1 != null;
        boolean inclusiveUpperBoundary = this.close == 93 && this.v2 != null;
        this.dd.add(new DefaultNVersionInterval(inclusiveLowerBoundary, inclusiveUpperBoundary, this.v1, this.v2, this.versionComparator));
        this.reset();
    }

    public NOptional<List<NVersionInterval>> parse(String version) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(version));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        block37: for (int i = 33; i < 256; ++i) {
            switch ((char)i) {
                case '(': 
                case ')': 
                case ',': 
                case '[': 
                case ']': {
                    continue block37;
                }
                default: {
                    st.wordChars(i, i);
                }
            }
        }
        try {
            block38: while ((this.t = st.nextToken()) != -1) {
                switch (this.state) {
                    case 1: {
                        switch (this.t) {
                            case -3: {
                                this.addNextValue(st.sval);
                                this.state = 2;
                                continue block38;
                            }
                            case 40: 
                            case 91: 
                            case 93: {
                                this.open = this.t;
                                this.state = 3;
                                continue block38;
                            }
                            case 44: {
                                continue block38;
                            }
                        }
                        return NOptional.ofError(() -> NMsg.ofC("unexpected  %s", Character.valueOf((char)this.t)));
                    }
                    case 2: {
                        switch (this.t) {
                            case 44: {
                                this.state = 1;
                                continue block38;
                            }
                        }
                        return NOptional.ofError(() -> NMsg.ofC("expected ',' found %s", Character.valueOf((char)this.t)));
                    }
                    case 3: {
                        switch (this.t) {
                            case -3: {
                                this.v1 = st.sval;
                                this.state = 4;
                                continue block38;
                            }
                            case 44: {
                                this.state = 5;
                                continue block38;
                            }
                        }
                        return NOptional.ofError(() -> NMsg.ofC("unexpected %s", Character.valueOf((char)this.t)));
                    }
                    case 4: {
                        switch (this.t) {
                            case 44: {
                                this.state = 5;
                                continue block38;
                            }
                            case 93: {
                                this.close = this.t;
                                this.v2 = this.v1;
                                this.addNextInterval();
                                this.state = 2;
                                continue block38;
                            }
                            case 41: 
                            case 91: {
                                this.close = this.t;
                                this.v2 = this.v1;
                                this.addNextInterval();
                                this.state = 2;
                                continue block38;
                            }
                        }
                        return NOptional.ofError(() -> NMsg.ofC("unexpected %s", Character.valueOf((char)this.t)));
                    }
                    case 5: {
                        switch (this.t) {
                            case -3: {
                                this.v2 = st.sval;
                                this.state = 6;
                                continue block38;
                            }
                            case 41: 
                            case 91: 
                            case 93: {
                                this.close = this.t;
                                this.addNextInterval();
                                this.state = 2;
                                continue block38;
                            }
                        }
                        return NOptional.ofError(() -> NMsg.ofC("unexpected %s", Character.valueOf((char)this.t)));
                    }
                    case 6: {
                        switch (this.t) {
                            case 41: 
                            case 91: 
                            case 93: {
                                this.close = this.t;
                                this.addNextInterval();
                                this.state = 2;
                                continue block38;
                            }
                        }
                        return NOptional.ofError(() -> NMsg.ofC("unexpected %s", Character.valueOf((char)this.t)));
                    }
                }
                return NOptional.ofError(() -> NMsg.ofC("unsupported state %s", this.state));
            }
            if (this.state != 2 && this.state != 1) {
                return NOptional.ofError(() -> NMsg.ofC("invalid state %s", this.state));
            }
        }
        catch (IOException ex) {
            return NOptional.ofError(() -> NMsg.ofC("parse version failed: %s : ", version, ex));
        }
        return NOptional.ofNamed(this.dd, "version");
    }
}

