/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.optional;

import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.internal.optional.NReservedOptionalEmpty;
import net.thevpc.nuts.internal.optional.NReservedOptionalValid;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;

public class NReservedOptionalValidCallable<T>
extends NReservedOptionalValid<T>
implements Cloneable {
    private final NCallable<NOptional<T>> value;
    private NOptional<T> result;
    private boolean evaluated;
    private Supplier<NMsg> msg;

    public NReservedOptionalValidCallable(NCallable<NOptional<T>> value) {
        NAssert.requireNonNull(value, "callable");
        this.value = value;
    }

    public NReservedOptionalValidCallable(NCallable<NOptional<T>> value, Supplier<NMsg> msg) {
        NAssert.requireNonNull(value, "callable");
        this.value = value;
        this.msg = msg;
    }

    @Override
    public NOptional<T> withMessage(Supplier<NMsg> message) {
        return new NReservedOptionalEmpty(message);
    }

    @Override
    public NOptional<T> withMessage(NMsg message) {
        if (this.evaluated) {
            if (message == null) {
                return this.result;
            }
            return this.result.withMessage(message);
        }
        return new NReservedOptionalValidCallable<T>(this.value, message == null ? () -> NMsg.ofMissingValue() : () -> message);
    }

    @Override
    public NOptional<T> withName(NMsg name) {
        if (this.evaluated) {
            if (name == null) {
                return this.result;
            }
            return this.result.withName(name);
        }
        return new NReservedOptionalValidCallable<T>(this.value, name == null ? () -> NMsg.ofMissingValue() : () -> NMsg.ofMissingValue(name));
    }

    @Override
    public NOptional<T> withName(String name) {
        if (this.evaluated) {
            if (name == null) {
                return this.result;
            }
            return this.result.withName(name);
        }
        return new NReservedOptionalValidCallable<T>(this.value, name == null ? () -> NMsg.ofMissingValue() : () -> NMsg.ofMissingValue(name));
    }

    @Override
    public <V> NOptional<V> then(Function<T, V> mapper) {
        NAssert.requireNonNull(mapper);
        if (this.evaluated) {
            if (this.result != null) {
                if (this.result.isPresent()) {
                    T v = this.result.get();
                    try {
                        V r = mapper.apply(v);
                        if (this.msg != null) {
                            return NOptional.of(r, this.msg);
                        }
                        return NOptional.of(r);
                    }
                    catch (Exception ex) {
                        if (this.msg != null) {
                            return NOptional.ofError(this.msg, (Throwable)ex);
                        }
                        return NOptional.ofError(ex);
                    }
                }
                if (this.msg != null) {
                    return this.result.withMessage(this.msg);
                }
                return this.result;
            }
            return NOptional.ofEmpty(this.getMessage());
        }
        return new NReservedOptionalValidCallable<T>(() -> {
            if (this.msg == null) {
                try {
                    T y = this.get();
                    if (y != null) {
                        Object v = mapper.apply(y);
                        return NOptional.of(v);
                    }
                    return null;
                }
                catch (Exception ex) {
                    if (this.msg != null) {
                        return NOptional.ofError(this.msg, (Throwable)ex);
                    }
                    return NOptional.ofError(ex);
                }
            }
            try {
                T y = this.get();
                if (y != null) {
                    Object v = mapper.apply(y);
                    return NOptional.of(v, this.msg);
                }
                return null;
            }
            catch (Exception ex) {
                if (this.msg != null) {
                    return NOptional.ofError(this.msg, (Throwable)ex);
                }
                return NOptional.ofError(ex);
            }
        }, this.msg);
    }

    @Override
    public Supplier<NMsg> getMessage() {
        return this.msg == null ? () -> NMsg.ofMissingValue() : this.msg;
    }

    @Override
    public T get() {
        if (!this.evaluated) {
            this.result = this.value.call();
            if (this.result == null) {
                this.result = NOptional.ofEmpty(this.getMessage());
            }
            this.evaluated = true;
        }
        return this.result.get();
    }

    @Override
    public NElement describe() {
        if (this.evaluated) {
            return NElement.ofUpletBuilder("Optional").add("evaluated", true).add("error", this.result.isError()).add("empty", this.result.isEmpty()).add("value", NElementDescribables.describeResolveOrDestruct(this.result.get())).build();
        }
        return NElement.ofUpletBuilder("Optional").add("evaluated", false).add("expression", NElementDescribables.describeResolveOrDestruct(this.value)).build();
    }
}

