/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.optional;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.internal.optional.NReservedOptionalImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NOptionalType;

public abstract class NReservedOptionalValid<T>
extends NReservedOptionalImpl<T>
implements Cloneable {
    @Override
    public <V> NOptional<V> then(Function<T, V> mapper) {
        Object y = this.get();
        if (y != null) {
            try {
                return NOptional.of(mapper.apply(y));
            }
            catch (Exception ex) {
                return NOptional.ofError(this.getMessage(), (Throwable)ex);
            }
        }
        return NOptional.ofEmpty(this.getMessage());
    }

    @Override
    public Optional<T> asOptional() {
        return Optional.of(this.get());
    }

    @Override
    public T get(Supplier<NMsg> message) {
        return this.get();
    }

    @Override
    public Throwable getError() {
        return null;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public NOptional<T> ifBlankEmpty() {
        if (this.isBlank()) {
            return NOptional.ofEmpty(NMsg::ofMissingValue);
        }
        return this;
    }

    @Override
    public Supplier<NMsg> getMessage() {
        return NMsg::ofMissingValue;
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.get());
    }

    public String toString() {
        return "Optional@" + System.identityHashCode(this) + "=" + this.get();
    }

    @Override
    public NOptional<T> withDefault(T value) {
        return this;
    }

    @Override
    public NOptional<T> withoutDefault() {
        return this;
    }

    @Override
    public T orDefault() {
        return this.get();
    }

    @Override
    public NOptional<T> orDefaultOptional() {
        return this;
    }

    @Override
    public NOptional<T> withDefault(Supplier<T> value) {
        return this;
    }

    @Override
    public NOptional<T> withDefaultOptional(Supplier<NOptional<T>> value) {
        return this;
    }

    @Override
    public boolean isNull() {
        return this.get() == null;
    }

    @Override
    public NOptionalType getType() {
        return NOptionalType.PRESENT;
    }

    @Override
    public NOptional<T> withExceptionFactory(NOptional.ExceptionFactory exceptionFactory) {
        return this;
    }
}

