/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.optional;

import java.util.function.Supplier;
import net.thevpc.nuts.internal.optional.NReservedOptionalImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public abstract class NReservedOptionalThrowable<T>
extends NReservedOptionalImpl<T>
implements Cloneable {
    private static boolean DEBUG;
    private Throwable rootStack = DEBUG ? new Throwable() : null;
    private Supplier<NOptional<T>> defaultValue;

    @Override
    public T orDefault() {
        if (this.defaultValue == null) {
            return null;
        }
        NOptional<T> o = this.defaultValue.get();
        if (o == null) {
            return null;
        }
        return o.orDefault();
    }

    @Override
    public NOptional<T> orDefaultOptional() {
        if (this.defaultValue == null) {
            return null;
        }
        NOptional<T> o = this.defaultValue.get();
        if (o == null) {
            return NOptional.ofEmpty(this.getMessage());
        }
        return o.orDefaultOptional();
    }

    protected NMsg prepareMessage(NMsg m) {
        if (DEBUG) {
            return NMsg.ofC("%s.\n    call stack:\n%s\n    root stack:\n%s", m, NStringUtils.stacktrace(new Throwable()), NStringUtils.stacktrace(this.rootStack));
        }
        if (m == null) {
            m = NMsg.ofMissingValue();
        }
        return m;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public NOptional<T> withDefault(Supplier<T> value) {
        NReservedOptionalThrowable c = (NReservedOptionalThrowable)this.clone();
        c.defaultValue = value == null ? null : () -> NOptional.of(value.get());
        return c;
    }

    @Override
    public NOptional<T> withDefaultOptional(Supplier<NOptional<T>> value) {
        NReservedOptionalThrowable c = (NReservedOptionalThrowable)this.clone();
        c.defaultValue = value == null ? null : () -> {
            NOptional i = (NOptional)value.get();
            if (i == null) {
                return NOptional.ofEmpty(this.getMessage());
            }
            return this;
        };
        return c;
    }

    @Override
    public NOptional<T> withDefault(T value) {
        NReservedOptionalThrowable c = (NReservedOptionalThrowable)this.clone();
        c.defaultValue = value == null ? null : () -> NOptional.of(value);
        return c;
    }

    @Override
    public NOptional<T> withoutDefault() {
        NReservedOptionalThrowable c = (NReservedOptionalThrowable)this.clone();
        c.defaultValue = null;
        return c;
    }

    protected NOptional<T> clone() {
        try {
            return (NOptional)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String property = System.getProperty("nuts.optional.debug");
        DEBUG = Boolean.parseBoolean(property);
    }
}

