/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.optional;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.internal.optional.NReservedOptionalEmpty;
import net.thevpc.nuts.internal.optional.NReservedOptionalThrowable;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NDetachedErrorOptionalException;
import net.thevpc.nuts.util.NErrorOptionalException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NOptionalType;

public class NReservedOptionalError<T>
extends NReservedOptionalThrowable<T>
implements Cloneable {
    private Supplier<NMsg> message;
    private Throwable cause;

    public NReservedOptionalError(Supplier<NMsg> message, Throwable cause) {
        if (message == null) {
            message = () -> NMsg.ofInvalidValue(cause);
        }
        this.message = message;
        this.cause = cause;
    }

    @Override
    public NOptional<T> withMessage(Supplier<NMsg> message) {
        return new NReservedOptionalEmpty(message);
    }

    @Override
    public NOptional<T> withMessage(NMsg message) {
        return new NReservedOptionalEmpty(message == null ? () -> NMsg.ofInvalidValue(this.cause) : () -> message);
    }

    @Override
    public NOptional<T> withName(NMsg name) {
        return new NReservedOptionalEmpty(name == null ? () -> NMsg.ofInvalidValue(this.cause) : () -> NMsg.ofInvalidValue(this.cause, name));
    }

    @Override
    public NOptional<T> withName(String name) {
        return new NReservedOptionalEmpty(name == null ? () -> NMsg.ofInvalidValue(this.cause) : () -> NMsg.ofInvalidValue(this.cause, name));
    }

    @Override
    public <V> NOptional<V> then(Function<T, V> mapper) {
        NAssert.requireNonNull(mapper);
        return this;
    }

    @Override
    public NOptionalType getType() {
        return NOptionalType.ERROR;
    }

    @Override
    public Throwable getError() {
        return this.cause;
    }

    @Override
    public T get() {
        this.throwError(this.message);
        return null;
    }

    @Override
    public T get(Supplier<NMsg> message) {
        this.throwError(message);
        return null;
    }

    @Override
    public NOptional<T> ifBlankEmpty() {
        return this;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isNotPresent() {
        return true;
    }

    @Override
    public Supplier<NMsg> getMessage() {
        return this.message;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    public String toString() {
        return "ErrorOptional@" + System.identityHashCode(this);
    }

    @Override
    protected NOptional<T> clone() {
        return super.clone();
    }

    protected void throwError(Supplier<NMsg> preferredMessage) {
        if (preferredMessage == null) {
            preferredMessage = this.message;
        }
        if (preferredMessage == null) {
            preferredMessage = NMsg::ofMissingValue;
        }
        Supplier<NMsg> finalMessage = preferredMessage;
        NMsg eMsg = NApiUtilsRPI.resolveValidErrorMessage(() -> finalMessage == null ? null : (NMsg)finalMessage.get());
        NMsg m = this.prepareMessage(eMsg);
        RuntimeException exception = null;
        NOptional.ExceptionFactory exceptionFactory = this.getExceptionFactory();
        if (exceptionFactory != null) {
            exception = exceptionFactory.createOptionalErrorException(m, this.cause);
        }
        if (exception == null && (exceptionFactory = NOptional.getDefaultExceptionFactory()) != null) {
            exception = exceptionFactory.createOptionalErrorException(m, this.cause);
        }
        if (exception == null) {
            exception = !NWorkspace.get().isPresent() ? new NErrorOptionalException(preferredMessage.get(), this.cause) : new NDetachedErrorOptionalException(preferredMessage.get(), this.cause);
        }
        throw exception;
    }

    @Override
    public Optional<T> asOptional() {
        return Optional.empty();
    }

    @Override
    public NElement describe() {
        return NElement.ofUpletBuilder("Optional").add("evaluated", true).add("empty", false).add("error", true).build();
    }
}

