/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.optional;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.internal.optional.NReservedOptionalThrowable;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NDetachedEmptyOptionalException;
import net.thevpc.nuts.util.NEmptyOptionalException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NOptionalType;

public class NReservedOptionalEmpty<T>
extends NReservedOptionalThrowable<T>
implements Cloneable {
    private Supplier<NMsg> message;

    public NReservedOptionalEmpty(Supplier<NMsg> message) {
        if (message == null) {
            message = NMsg::ofMissingValue;
        }
        this.message = message;
    }

    @Override
    public NOptional<T> withMessage(Supplier<NMsg> message) {
        return new NReservedOptionalEmpty<T>(message);
    }

    @Override
    public NOptional<T> withMessage(NMsg message) {
        return new NReservedOptionalEmpty<T>(message == null ? NMsg::ofMissingValue : () -> message);
    }

    @Override
    public NOptional<T> withName(NMsg name) {
        return new NReservedOptionalEmpty<T>(name == null ? NMsg::ofMissingValue : () -> NMsg.ofMissingValue(name));
    }

    @Override
    public NOptional<T> withName(String name) {
        return new NReservedOptionalEmpty<T>(name == null ? NMsg::ofMissingValue : () -> NMsg.ofMissingValue(name));
    }

    @Override
    public Optional<T> asOptional() {
        return Optional.empty();
    }

    @Override
    public T get() {
        this.throwError(this.message);
        return null;
    }

    @Override
    public T get(Supplier<NMsg> message) {
        this.throwError(message);
        return null;
    }

    @Override
    public <V> NOptional<V> then(Function<T, V> mapper) {
        NAssert.requireNonNull(mapper);
        return NOptional.ofEmpty(this.getMessage());
    }

    @Override
    public Throwable getError() {
        return null;
    }

    @Override
    public NOptionalType getType() {
        return NOptionalType.EMPTY;
    }

    @Override
    public NOptional<T> ifBlankEmpty() {
        return this;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isNotPresent() {
        return true;
    }

    @Override
    public Supplier<NMsg> getMessage() {
        return this.message;
    }

    @Override
    public boolean isBlank() {
        return true;
    }

    public String toString() {
        return "EmptyOptional@" + System.identityHashCode(this);
    }

    @Override
    protected NOptional<T> clone() {
        return super.clone();
    }

    protected void throwError(Supplier<NMsg> preferredMessage) {
        if (preferredMessage == null) {
            preferredMessage = this.message;
        }
        if (preferredMessage == null) {
            preferredMessage = NMsg::ofMissingValue;
        }
        Supplier<NMsg> finalMessage = preferredMessage;
        NMsg eMsg = NApiUtilsRPI.resolveValidErrorMessage(() -> finalMessage == null ? null : (NMsg)finalMessage.get());
        NMsg m = this.prepareMessage(eMsg);
        RuntimeException exception = null;
        NOptional.ExceptionFactory exceptionFactory = this.getExceptionFactory();
        if (exceptionFactory != null) {
            exception = exceptionFactory.createOptionalEmptyException(m);
        }
        if (exception == null && (exceptionFactory = NOptional.getDefaultExceptionFactory()) != null) {
            exception = exceptionFactory.createOptionalEmptyException(m);
        }
        if (exception == null) {
            exception = !NWorkspace.get().isPresent() ? new NEmptyOptionalException(preferredMessage.get()) : new NDetachedEmptyOptionalException(preferredMessage.get());
        }
        throw exception;
    }

    @Override
    public NElement describe() {
        return NElement.ofUpletBuilder("Optional").add("evaluated", true).add("empty", true).add("error", false).build();
    }
}

