/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NOpenMode;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NSupportMode;

public class NReservedWorkspaceOptionsToCmdLineBuilder {
    private static final String V080 = "0.8.0";
    private static final String V081 = "0.8.1";
    private static final String V083 = "0.8.3";
    private static final String V084 = "0.8.4";
    private static final String V085 = "0.8.5";
    private static final String V086 = "0.8.6";
    private static final String V087 = "0.8.7";
    private NWorkspaceOptionsConfig config;
    private NWorkspaceOptions options;

    public NReservedWorkspaceOptionsToCmdLineBuilder(NWorkspaceOptionsConfig config, NWorkspaceOptions options) {
        this.config = config;
        this.options = options;
    }

    private void fillOption(String longName, String shortName, List<String> values, String sep, List<String> arguments, boolean forceSingle) {
        if (values != null && values.size() > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.join((CharSequence)sep, values), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, String[] values, String sep, List<String> arguments, boolean forceSingle) {
        if (values != null && values.length > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.join((CharSequence)sep, values), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, Boolean value, boolean defaultValue, List<String> arguments, boolean forceSingle) {
        if (value != null) {
            if (defaultValue) {
                if (!value.booleanValue()) {
                    if (this.config.isShortOptions() && shortName != null) {
                        arguments.add("-!" + shortName.substring(1));
                    } else if (longName.startsWith("---")) {
                        arguments.add("---!" + longName.substring(3));
                    } else {
                        arguments.add("--!" + longName.substring(2));
                    }
                }
            } else if (value.booleanValue()) {
                arguments.add(this.selectOptionName(longName, shortName));
            }
        }
    }

    private void fillOption(String longName, String shortName, char[] value, List<String> arguments, boolean forceSingle) {
        if (value != null && new String(value).isEmpty()) {
            this.fillOption0(this.selectOptionName(longName, shortName), new String(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, String value, List<String> arguments, boolean forceSingle) {
        if (!NBlankable.isBlank(value)) {
            this.fillOption0(this.selectOptionName(longName, shortName), value, arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, int value, List<String> arguments, boolean forceSingle) {
        if (value > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.valueOf(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, Enum value, Class enumType, List<String> arguments, boolean forceSingle) {
        if (this.tryFillOptionShort(value, arguments, forceSingle)) {
            return;
        }
        if (value != null) {
            if (this.config.isShortOptions()) {
                if (value instanceof NOsFamily) {
                    switch ((NOsFamily)value) {
                        case LINUX: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("linux", "l"), arguments, forceSingle);
                            return;
                        }
                        case WINDOWS: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("windows", "w"), arguments, forceSingle);
                            return;
                        }
                        case MACOS: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("macos", "m"), arguments, forceSingle);
                            return;
                        }
                        case UNIX: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("unix", "u"), arguments, forceSingle);
                            return;
                        }
                        case UNKNOWN: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("unknown", "x"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if (value instanceof NStoreStrategy) {
                    switch ((NStoreStrategy)value) {
                        case EXPLODED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("exploded", "e"), arguments, forceSingle);
                            return;
                        }
                        case STANDALONE: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("standalone", "s"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if (value instanceof NTerminalMode) {
                    switch ((NTerminalMode)value) {
                        case FILTERED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("no", "n"), arguments, forceSingle);
                            return;
                        }
                        case INHERITED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("inherited", "h"), arguments, forceSingle);
                            return;
                        }
                        case FORMATTED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("yes", "y"), arguments, forceSingle);
                            return;
                        }
                        case DEFAULT: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("default", null), arguments, forceSingle);
                            return;
                        }
                    }
                }
            }
            NVersion apiVersionObj = this.config.getApiVersion();
            if (value instanceof NSupportMode && !this.isApiVersionOrAfter(V084)) {
                switch ((NSupportMode)value) {
                    case ALWAYS: {
                        this.fillOption0(this.selectOptionName(longName, shortName), "preferred", arguments, forceSingle);
                        return;
                    }
                    case NEVER: {
                        this.fillOption0(this.selectOptionName(longName, shortName), "unsupported", arguments, forceSingle);
                        return;
                    }
                }
            }
            if (value instanceof NEnum) {
                this.fillOption0(this.selectOptionName(longName, shortName), ((NEnum)((Object)value)).id(), arguments, forceSingle);
            } else {
                this.fillOption0(this.selectOptionName(longName, shortName), value.toString().toLowerCase(), arguments, forceSingle);
            }
        }
    }

    private boolean fillOption(NRunAs value, List<String> arguments) {
        if (value == null) {
            return false;
        }
        NVersion apiVersion = this.options.getApiVersion().orNull();
        switch (value.getMode()) {
            case CURRENT_USER: {
                if (this.isApiVersionOrAfter(V081)) {
                    if (!this.config.isOmitDefaults()) {
                        arguments.add("--current-user");
                    }
                } else {
                    arguments.add("--user-cmd");
                }
                return true;
            }
            case ROOT: {
                if (this.isApiVersionOrAfter(V081)) {
                    arguments.add("--as-root");
                } else {
                    arguments.add("--root-cmd");
                }
                return true;
            }
            case SUDO: {
                if (this.isApiVersionOrAfter(V081)) {
                    arguments.add("--sudo");
                }
                return true;
            }
            case USER: {
                if (this.isApiVersionOrAfter(V081)) {
                    arguments.add("--run-as=" + value.getUser());
                }
                return true;
            }
        }
        throw new UnsupportedOperationException("unsupported " + value.getMode());
    }

    private boolean tryFillOptionShort(Enum value, List<String> arguments, boolean forceSingle) {
        NVersion apiVersion = this.options.getApiVersion().orNull();
        if (value != null && this.config.isShortOptions()) {
            if (value instanceof NOpenMode) {
                switch ((NOpenMode)value) {
                    case OPEN_OR_ERROR: {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-error", "r"), arguments, forceSingle);
                        return true;
                    }
                    case CREATE_OR_ERROR: {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("create-or-error", "w"), arguments, forceSingle);
                        return true;
                    }
                    case OPEN_OR_CREATE: {
                        if (!this.config.isOmitDefaults()) {
                            this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-create", "rw"), arguments, forceSingle);
                        }
                        return true;
                    }
                    case OPEN_OR_NULL: {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-null", "on"), arguments, forceSingle);
                        return true;
                    }
                }
            }
            if (value instanceof NExecutionType) {
                switch ((NExecutionType)value) {
                    case SYSTEM: {
                        if (this.isApiVersionOrAfter(V081)) {
                            arguments.add("--system");
                        } else {
                            arguments.add("--user-cmd");
                        }
                        return true;
                    }
                    case EMBEDDED: {
                        arguments.add(this.selectOptionName("--embedded", "-b"));
                        return true;
                    }
                    case SPAWN: {
                        if (!this.config.isOmitDefaults()) {
                            arguments.add(this.selectOptionName("--spawn", "-x"));
                        }
                        return true;
                    }
                    case OPEN: {
                        arguments.add(this.selectOptionName("--open-file", "--open-file"));
                        return true;
                    }
                }
            }
            if (value instanceof NConfirmationMode) {
                switch ((NConfirmationMode)value) {
                    case YES: {
                        arguments.add(this.selectOptionName("--yes", "-y"));
                        return true;
                    }
                    case NO: {
                        arguments.add(this.selectOptionName("-no", "-n"));
                        return true;
                    }
                    case ASK: {
                        if (this.config.isOmitDefaults()) break;
                        arguments.add("--ask");
                        return true;
                    }
                    case ERROR: {
                        arguments.add("--error");
                        return true;
                    }
                }
            }
            if (value instanceof NTerminalMode) {
                NVersion apiVersionObj = this.config.getApiVersion();
                switch ((NTerminalMode)value) {
                    case FILTERED: {
                        if (this.isApiVersionOrAfter(V084)) {
                            arguments.add("--color=filtered");
                        } else {
                            arguments.add(this.selectOptionName("--!color", "-!c"));
                        }
                        return true;
                    }
                    case FORMATTED: {
                        arguments.add(this.selectOptionName("--color", "-c"));
                        return true;
                    }
                    case INHERITED: {
                        arguments.add(this.selectOptionName("--color=inherited", "-c=h"));
                        return true;
                    }
                    case ANSI: {
                        arguments.add(this.selectOptionName("--color=ansi", "-c=a"));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fillOption(Enum value, List<String> arguments, boolean forceSingle) {
        if (value != null) {
            if (this.tryFillOptionShort(value, arguments, forceSingle)) {
                return;
            }
            if (value instanceof NEnum) {
                arguments.add("--" + ((NEnum)((Object)value)).id());
            } else {
                arguments.add("--" + NNameFormat.CONST_NAME.format(value.name()));
            }
        }
    }

    private String selectOptionVal(String longName, String shortName) {
        if (this.config.isShortOptions()) {
            return shortName;
        }
        return longName;
    }

    private String selectOptionName(String longName, String shortName) {
        if (this.config.isShortOptions() && shortName != null) {
            return shortName;
        }
        return longName;
    }

    private void fillOption0(String name, String value, List<String> arguments, boolean forceSingle) {
        if (this.config.isSingleArgOptions() || forceSingle) {
            arguments.add(name + "=" + value);
        } else {
            arguments.add(name);
            arguments.add(value);
        }
    }

    public NCmdLine toCmdLine() {
        NLogConfig logConfig;
        NVersion apiVersionObj = this.config.getApiVersion();
        ArrayList<String> arguments = new ArrayList<String>();
        this.fillOption("--java", "-j", this.options.getJavaCommand().orNull(), arguments, false);
        this.fillOption("--java-options", "-O", this.options.getJavaOptions().orNull(), arguments, false);
        String wsString = this.options.getWorkspace().orNull();
        if (NBlankable.isBlank(wsString)) {
            wsString = "";
        } else if (wsString.contains("/") || wsString.contains("\\")) {
            wsString = new File(wsString).toPath().toAbsolutePath().normalize().toString();
        }
        this.fillOption("--workspace", "-w", wsString, arguments, false);
        this.fillOption("--user", "-u", this.options.getUserName().orNull(), arguments, false);
        this.fillOption("--password", "-p", this.options.getCredentials().orNull(), arguments, false);
        this.fillOption("--boot-version", "-V", this.options.getApiVersion().map(Object::toString).orNull(), arguments, false);
        this.fillOption("--boot-runtime", null, this.options.getRuntimeId().map(Object::toString).orNull(), arguments, false);
        NTerminalMode nTerminalMode = this.options.getTerminalMode().orNull();
        if (!this.isApiVersionOrAfter(V084) && this.options.getBot().orElse(false).booleanValue()) {
            nTerminalMode = NTerminalMode.FILTERED;
        }
        if (!this.config.isOmitDefaults() || nTerminalMode != NTerminalMode.FORMATTED) {
            this.fillOption("--color", "-c", nTerminalMode, NTerminalMode.class, arguments, true);
        }
        if ((logConfig = this.options.getLogConfig().orNull()) != null) {
            if (logConfig.getLogTermLevel() != null && logConfig.getLogTermLevel() == logConfig.getLogFileLevel()) {
                this.fillOption("--log-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
            } else {
                if (logConfig.getLogTermLevel() != null) {
                    this.fillOption("--log-term-" + logConfig.getLogTermLevel().toString().toLowerCase(), null, true, false, arguments, false);
                }
                if (logConfig.getLogFileLevel() != null) {
                    this.fillOption("--log-file-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
                }
            }
            if (logConfig.getLogFileCount() > 0) {
                this.fillOption("--log-file-count", null, String.valueOf(logConfig.getLogFileCount()), arguments, false);
            }
            this.fillOption("--log-file-size", null, logConfig.getLogFileSize(), arguments, false);
            this.fillOption("--log-file-base", null, logConfig.getLogFileBase(), arguments, false);
            this.fillOption("--log-file-name", null, logConfig.getLogFileName(), arguments, false);
        }
        this.fillOption("--exclude-extension", "-X", this.options.getExcludedExtensions().orElseGet(Collections::emptyList), ";", arguments, false);
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--repositories", "-r", this.options.getRepositories().orElseGet(Collections::emptyList), ";", arguments, false);
        } else {
            this.fillOption("--repository", "-r", this.options.getRepositories().orElseGet(Collections::emptyList), ";", arguments, false);
        }
        this.fillOption("--global", "-g", this.options.getSystem().orNull(), false, arguments, false);
        this.fillOption("--gui", null, this.options.getGui().orNull(), false, arguments, false);
        this.fillOption("--read-only", "-R", this.options.getReadOnly().orNull(), false, arguments, false);
        this.fillOption("--trace", "-t", this.options.getTrace().orNull(), true, arguments, false);
        this.fillOption("--progress", "-P", this.options.getProgressOptions().orNull(), arguments, true);
        this.fillOption("--solver", null, this.options.getDependencySolver().orNull(), arguments, false);
        if (this.isApiVersionOrAfter(V083)) {
            this.fillOption("--debug", null, this.options.getDebug().orNull(), arguments, true);
        } else {
            this.fillOption("--debug", null, this.options.getDebug().isPresent(), false, arguments, true);
        }
        this.fillOption("--install-companions", "-k", this.options.getInstallCompanions().orNull(), false, arguments, false);
        this.fillOption("--skip-welcome", "-K", this.options.getSkipWelcome().orElse(false), false, arguments, false);
        this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix().orNull(), arguments, false);
        this.fillOption("--skip-boot", "-Q", this.options.getSkipBoot().orNull(), false, arguments, false);
        this.fillOption("--cached", null, this.options.getCached().orNull(), true, arguments, false);
        this.fillOption("--indexed", null, this.options.getIndexed().orNull(), true, arguments, false);
        this.fillOption("--transitive", null, this.options.getTransitive().orNull(), true, arguments, false);
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--bot", "-B", this.options.getBot().orNull(), false, arguments, false);
        }
        if (this.isApiVersionOrAfter(V085)) {
            this.fillOption("--preview-repo", "-U", this.options.getPreviewRepo().orNull(), false, arguments, false);
            this.fillOption("--shared-instance", null, this.options.getSharedInstance().orNull(), false, arguments, false);
        }
        if (this.options.getFetchStrategy().isPresent() && this.options.getFetchStrategy().orNull() != NFetchStrategy.ONLINE) {
            this.fillOption("--fetch", "-f", this.options.getFetchStrategy().orNull(), NFetchStrategy.class, arguments, false);
        }
        this.fillOption(this.options.getConfirm().orNull(), arguments, false);
        this.fillOption(this.options.getOutputFormat().orNull(), arguments, false);
        for (NStoreType[] outputFormatOption : this.options.getOutputFormatOptions().orElseGet(Collections::emptyList)) {
            this.fillOption("--output-format-option", "-T", (String)outputFormatOption, arguments, false);
        }
        if (this.isApiVersionOrAfter(V080)) {
            this.fillOption("--expire", "-N", this.options.getExpireTime().map(Object::toString).orNull(), arguments, false);
            if (this.options.getOutLinePrefix().isPresent() && Objects.equals(this.options.getOutLinePrefix(), this.options.getErrLinePrefix()) && this.options.getOutLinePrefix().get().length() > 0) {
                this.fillOption("--line-prefix", null, this.options.getOutLinePrefix().orNull(), arguments, false);
            } else {
                if (this.options.getOutLinePrefix().isPresent() && this.options.getOutLinePrefix().get().length() > 0) {
                    this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix().orNull(), arguments, false);
                }
                if (this.options.getErrLinePrefix().isPresent() && this.options.getErrLinePrefix().get().length() > 0) {
                    this.fillOption("--err-line-prefix", null, this.options.getErrLinePrefix().orNull(), arguments, false);
                }
            }
        }
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--theme", null, this.options.getTheme().orNull(), arguments, false);
        }
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--locale", "-L", this.options.getLocale().orNull(), arguments, false);
        }
        if (this.isApiVersionOrAfter(V084)) {
            this.fillOption("--init-launchers", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("--init-platforms", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("--init-java", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("--init-scripts", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("--desktop-launcher", null, this.options.getDesktopLauncher().orNull(), NSupportMode.class, arguments, false);
            this.fillOption("--menu-launcher", null, this.options.getDesktopLauncher().orNull(), NSupportMode.class, arguments, false);
            this.fillOption("--user-launcher", null, this.options.getDesktopLauncher().orNull(), NSupportMode.class, arguments, false);
            this.fillOption("--isolation-level", null, this.options.getIsolationLevel().orNull(), NIsolationLevel.class, arguments, false);
        } else if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("---init-launchers", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("---init-platforms", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("---init-java", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("---init-scripts", null, this.options.getInitLaunchers().orNull(), true, arguments, false);
            this.fillOption("---system-desktop-launcher", null, this.options.getDesktopLauncher().orNull(), NSupportMode.class, arguments, false);
            this.fillOption("---system-menu-launcher", null, this.options.getDesktopLauncher().orNull(), NSupportMode.class, arguments, false);
            this.fillOption("---system-custom-launcher", null, this.options.getDesktopLauncher().orNull(), NSupportMode.class, arguments, false);
        }
        this.fillOption("--name", null, NStringUtils.trim(this.options.getName().orNull()), arguments, false);
        this.fillOption("--archetype", "-A", this.options.getArchetype().orNull(), arguments, false);
        this.fillOption("--store-layout", null, this.options.getStoreLayout().orNull(), NOsFamily.class, arguments, false);
        this.fillOption("--store-strategy", null, this.options.getStoreStrategy().orNull(), NStoreStrategy.class, arguments, false);
        this.fillOption("--repo-store-strategy", null, this.options.getRepositoryStoreStrategy().orNull(), NStoreStrategy.class, arguments, false);
        Map storeLocations = this.options.getStoreLocations().orElseGet(Collections::emptyMap);
        for (NStoreType location : NStoreType.values()) {
            String string = (String)storeLocations.get(location);
            if (NBlankable.isBlank(string)) continue;
            this.fillOption("--" + location.id() + "-location", null, string, arguments, false);
        }
        Map homeLocations = this.options.getHomeLocations().orElseGet(Collections::emptyMap);
        if (homeLocations != null) {
            for (NStoreType nStoreType : NStoreType.values()) {
                String s = (String)homeLocations.get(NHomeLocation.of(null, nStoreType));
                if (NBlankable.isBlank(s)) continue;
                this.fillOption("--system-" + nStoreType.id() + "-home", null, s, arguments, false);
            }
            for (Enum enum_ : NOsFamily.values()) {
                for (NStoreType location : NStoreType.values()) {
                    String s = (String)homeLocations.get(NHomeLocation.of((NOsFamily)enum_, location));
                    if (NBlankable.isBlank(s)) continue;
                    this.fillOption("--" + ((NOsFamily)enum_).id() + "-" + location.id() + "-home", null, s, arguments, false);
                }
            }
        }
        if (this.isApiVersionOrAfter(V080) && this.options.getSwitchWorkspace().isPresent()) {
            this.fillOption("--switch", null, this.options.getSwitchWorkspace().orNull(), false, arguments, false);
        }
        this.fillOption("--help", "-h", this.options.getCommandHelp().orElse(false), false, arguments, false);
        this.fillOption("--version", "-v", this.options.getCommandVersion().orElse(false), false, arguments, false);
        if (!this.config.isOmitDefaults() || !this.options.getOpenMode().isNotPresent() && this.options.getOpenMode().orNull() != NOpenMode.OPEN_OR_CREATE) {
            this.fillOption(this.options.getOpenMode().orNull(), arguments, false);
        }
        this.fillOption(this.options.getExecutionType().orNull(), arguments, false);
        this.fillOption(this.options.getRunAs().orNull(), arguments);
        this.fillOption("--reset", "-Z", this.options.getReset().orNull(), false, arguments, false);
        this.fillOption("--recover", "-z", this.options.getRecover().orNull(), false, arguments, false);
        this.fillOption("--dry", "-D", this.options.getDry().orNull(), false, arguments, false);
        if (this.isApiVersionOrAfter(V085)) {
            this.fillOption("--reset-hard", null, this.options.getReset().orNull(), false, arguments, false);
        }
        if (this.isApiVersionOrAfter(V084)) {
            this.fillOption("--stacktrace", null, this.options.getShowStacktrace().orNull(), false, arguments, false);
        }
        if (this.isApiVersionOrAfter(V081) && this.options.getCustomOptions() != null) {
            arguments.addAll(this.options.getCustomOptions().orElseGet(Collections::emptyList));
        }
        if (!this.config.isOmitDefaults() && this.options.getApplicationArguments().isPresent() && !this.options.getApplicationArguments().get().isEmpty() || !this.options.getExecutorOptions().orElseGet(Collections::emptyList).isEmpty()) {
            arguments.add(this.selectOptionName("--exec", "-e"));
        }
        arguments.addAll(this.options.getExecutorOptions().orElseGet(Collections::emptyList));
        arguments.addAll(this.options.getApplicationArguments().orElseGet(Collections::emptyList));
        return NCmdLine.of(arguments);
    }

    private boolean isApiVersionOrAfter(String version) {
        NVersion apiVersionObj = this.config.getApiVersion();
        return apiVersionObj == null || apiVersionObj.compareTo(version) >= 0;
    }
}

