/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public final class NReservedLangUtils {
    public static <T> NOptional<T> findThrowable(Throwable th, Class<T> type, Predicate<Throwable> filter) {
        HashSet<Throwable> visited = new HashSet<Throwable>();
        Stack<Throwable> stack = new Stack<Throwable>();
        if (th != null) {
            stack.push(th);
        }
        while (!stack.isEmpty()) {
            Throwable a = (Throwable)stack.pop();
            if (!visited.add(a)) continue;
            if (type.isAssignableFrom(th.getClass()) && (filter == null || filter.test(th))) {
                return NOptional.of(th);
            }
            Throwable c = th.getCause();
            if (c != null) {
                stack.add(c);
            }
            if (!(th instanceof InvocationTargetException) || (c = ((InvocationTargetException)th).getTargetException()) == null) continue;
            stack.add(c);
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("error with type %s not found", type.getSimpleName()));
    }

    public static List<String> splitDefault(String str) {
        return NStringUtils.split(str, " ;,\n\r\t|", true, true);
    }

    public static List<String> parseAndTrimToDistinctList(String s) {
        if (s == null) {
            return new ArrayList<String>();
        }
        return NReservedLangUtils.splitDefault(s).stream().map(String::trim).filter(x -> x.length() > 0).distinct().collect(Collectors.toList());
    }

    public static String joinAndTrimToNull(List<String> args) {
        return NStringUtils.trimToNull(String.join((CharSequence)",", args));
    }

    public static NOptional<Integer> parseFileSizeInBytes(String value, Integer defaultMultiplier) {
        if (NBlankable.isBlank(value)) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty size"));
        }
        Integer i = NLiteral.of(value = value.trim()).asInt().orNull();
        if (i != null) {
            if (defaultMultiplier != null) {
                return NOptional.of(i * defaultMultiplier);
            }
            return NOptional.of(i);
        }
        for (String s : new String[]{"kb", "mb", "gb", "k", "m", "g"}) {
            String v;
            if (!value.toLowerCase().endsWith(s) || (i = NLiteral.of(v = value.substring(0, value.length() - s.length()).trim()).asInt().orNull()) == null) continue;
            switch (s) {
                case "k": 
                case "kb": {
                    return NOptional.of(i * 1024);
                }
                case "m": 
                case "mb": {
                    return NOptional.of(i * 1024 * 1024);
                }
                case "g": 
                case "gb": {
                    return NOptional.of(i * 1024 * 1024 * 1024);
                }
            }
        }
        String finalValue = value;
        return NOptional.ofError(() -> NMsg.ofC("invalid size :%s", finalValue));
    }

    public static <T, V> Map<T, V> nonNullMap(Map<T, V> other) {
        if (other == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap<T, V>(other);
    }

    public static <T> List<T> nonNullListFromArray(T[] other) {
        return NReservedLangUtils.nonNullList(Arrays.asList(other));
    }

    public static <T> List<T> unmodifiableOrNullList(Collection<T> other) {
        if (other == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<T>(other));
    }

    public static <T> Set<T> unmodifiableOrNullSet(Collection<T> other) {
        if (other == null) {
            return null;
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(other));
    }

    public static <T, V> Map<T, V> unmodifiableOrNullMap(Map<T, V> other) {
        if (other == null) {
            return null;
        }
        return Collections.unmodifiableMap(new LinkedHashMap<T, V>(other));
    }

    public static <T> List<T> copyOrNullList(Collection<T> other) {
        if (other == null) {
            return null;
        }
        return new ArrayList<T>(other);
    }

    public static <T> List<T> nonNullList(Collection<T> other) {
        if (other == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(other);
    }

    public static <T> Set<T> nonNullSet(Collection<T> other) {
        if (other == null) {
            return new LinkedHashSet();
        }
        return new LinkedHashSet<T>(other);
    }

    public static List<String> addUniqueNonBlankList(List<String> list, String ... values) {
        LinkedHashSet<String> newList = new LinkedHashSet<String>();
        if (list != null) {
            newList.addAll(list);
        }
        boolean someUpdates = false;
        if (values != null) {
            for (String value : values) {
                if (NBlankable.isBlank(value) || !newList.add(NStringUtils.trim(value))) continue;
                someUpdates = true;
            }
        }
        if (someUpdates) {
            list = new ArrayList<String>(newList);
        }
        return list;
    }

    public static <T> List<T> uniqueNonBlankList(Collection<T> other) {
        return NReservedLangUtils.uniqueList(other).stream().filter(x -> !NBlankable.isBlank(x)).collect(Collectors.toList());
    }

    public static <T> List<T> addUniqueNonBlankList(List<T> list, Collection<T> other) {
        if (other != null) {
            for (T t : other) {
                if (NBlankable.isBlank(t) || list.contains(t)) continue;
                list.add(t);
            }
        }
        return list;
    }

    public static <T> Set<T> nonBlankSet(Collection<T> other) {
        return NReservedLangUtils.set(other).stream().filter(x -> !NBlankable.isBlank(x)).collect(Collectors.toSet());
    }

    public static <T> List<T> uniqueList(Collection<T> other) {
        if (other == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(new LinkedHashSet<T>(other));
    }

    public static <T> Set<T> set(Collection<T> other) {
        if (other == null) {
            return new LinkedHashSet();
        }
        return new LinkedHashSet<T>(other);
    }

    public static <T> List<T> unmodifiableList(Collection<T> other) {
        return other == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(other));
    }

    public static <T, V> Map<T, V> unmodifiableMap(Map<T, V> other) {
        return other == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<T, V>(other));
    }

    public static <T> List<T> unmodifiableUniqueList(Collection<T> other) {
        return other == null ? Collections.emptyList() : Collections.unmodifiableList(NReservedLangUtils.uniqueList(other));
    }

    public static boolean isGraphicalDesktopEnvironment() {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                return false;
            }
            try {
                GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (screenDevices == null || screenDevices.length == 0) {
                    return false;
                }
            }
            catch (HeadlessException e) {
                return false;
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {}
        finally {
            return false;
        }
    }

    public static String inputString(String message, String title, Supplier<String> in, NLog bLog) {
        try {
            String line;
            if (title == null) {
                title = "Nuts Package Manager - " + Nuts.getVersion();
            }
            if ((line = JOptionPane.showInputDialog(null, message, title, 3)) == null) {
                line = "";
            }
            return line;
        }
        catch (UnsatisfiedLinkError e) {
            bLog.log(NMsg.ofC("[Graphical Environment Unsupported] %s", title).withLevel(Level.OFF).withIntent(NMsgIntent.ALERT));
            if (in == null) {
                return new Scanner(System.in).nextLine();
            }
            return in.get();
        }
    }

    public static void showMessage(String message, String title, NLog bLog) {
        if (title == null) {
            title = "Nuts Package Manager";
        }
        try {
            JOptionPane.showMessageDialog(null, message);
        }
        catch (UnsatisfiedLinkError e) {
            bLog.log(NMsg.ofC("[Graphical Environment Unsupported] %s", title).withLevel(Level.OFF).withIntent(NMsgIntent.ALERT));
        }
    }
}

