/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class NApiUtilsRPI {
    private static Logger LOG = Logger.getLogger(NApiUtilsRPI.class.getName());

    private NApiUtilsRPI() {
    }

    public static boolean isBlank(CharSequence s) {
        return s == null || NApiUtilsRPI.isBlank(s.toString().toCharArray());
    }

    public static boolean isBlank(Object any) {
        if (any == null) {
            return true;
        }
        if (any instanceof NBlankable) {
            return ((NBlankable)any).isBlank();
        }
        if (any instanceof CharSequence) {
            return NApiUtilsRPI.isBlank((CharSequence)any);
        }
        if (any instanceof char[]) {
            return NApiUtilsRPI.isBlank((char[])any);
        }
        if (any.getClass().isArray()) {
            return Array.getLength(any) == 0;
        }
        if (any instanceof Collection) {
            return ((Collection)any).isEmpty();
        }
        if (any instanceof Map) {
            return ((Map)any).isEmpty();
        }
        return false;
    }

    public static boolean isBlank(char[] string) {
        if (string == null || string.length == 0) {
            return true;
        }
        for (char c : string) {
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean resolveShowStackTrace(NWorkspaceOptions bo) {
        if (bo.getShowStacktrace().isPresent()) {
            return bo.getShowStacktrace().get();
        }
        if (bo.getBot().orElse(false).booleanValue()) {
            return false;
        }
        if (NApiUtilsRPI.getSysBoolNutsProperty("stacktrace", false)) {
            return true;
        }
        if (bo.getDebug().isPresent() && !NBlankable.isBlank(bo.getDebug().get())) {
            return true;
        }
        NLogConfig nLogConfig = bo.getLogConfig().orElseGet(NLogConfig::new);
        return nLogConfig.getLogTermLevel() != null && nLogConfig.getLogTermLevel().intValue() < Level.INFO.intValue();
    }

    public static boolean resolveShowStackTrace(NBootOptionsInfo bo) {
        if (bo.getShowStacktrace() != null) {
            return bo.getShowStacktrace();
        }
        if (bo.getBot() != null && bo.getBot().booleanValue()) {
            return false;
        }
        if (NApiUtilsRPI.getSysBoolNutsProperty("stacktrace", false)) {
            return true;
        }
        if (bo.getDebug() != null && !NBlankable.isBlank(bo.getDebug())) {
            return true;
        }
        NBootLogConfig nLogConfig = bo.getLogConfig();
        return nLogConfig != null && nLogConfig.getLogTermLevel() != null && nLogConfig.getLogTermLevel().intValue() < Level.INFO.intValue();
    }

    public static boolean resolveGui(NWorkspaceOptions bo) {
        if (bo.getBot().orElse(false).booleanValue()) {
            return false;
        }
        if (bo.getGui().orElse(false).booleanValue()) {
            return NApiUtilsRPI.isGraphicalDesktopEnvironment();
        }
        return false;
    }

    public static boolean resolveGui(NBootOptionsInfo bo) {
        if (bo.getBot() != null && bo.getBot().booleanValue()) {
            return false;
        }
        if (bo.getGui() != null && bo.getGui().booleanValue()) {
            return NApiUtilsRPI.isGraphicalDesktopEnvironment();
        }
        return false;
    }

    public static boolean isGraphicalDesktopEnvironment() {
        return NReservedLangUtils.isGraphicalDesktopEnvironment();
    }

    public static boolean getSysBoolNutsProperty(String property, boolean defaultValue) {
        return NReservedUtils.getSysBoolNutsProperty(property, defaultValue);
    }

    public static NOptional<Integer> parseFileSizeInBytes(String value, Integer defaultMultiplier) {
        return NReservedLangUtils.parseFileSizeInBytes(value, defaultMultiplier);
    }

    public static <T> T getOrCreateRefProperty(String name, Class<T> type, Supplier<T> sup) {
        if (NBlankable.isBlank(name = NStringUtils.trim(name))) {
            name = "default";
        }
        String key = type.getName() + "(" + name + ")";
        return (T)NApp.of().getOrComputeProperty(key, NScopeType.SESSION, () -> sup.get());
    }

    public static <T> T getOrCreateRefProperty(Class<T> type, Supplier<T> sup) {
        return NApiUtilsRPI.getOrCreateRefProperty("default", type, sup);
    }

    public static NMsg resolveValidErrorMessage(Supplier<NMsg> supplier) {
        NMsg t;
        if (supplier == null) {
            NMsg m = NMsg.ofC("unexpected error : %s", "empty message supplier");
            LOG.log(Level.SEVERE, new Throwable(m.toString()), m::toString);
            return m;
        }
        try {
            t = supplier.get();
        }
        catch (Exception ex) {
            NMsg m = NMsg.ofC("unexpected error : %s", "message builder failed with : " + ex);
            LOG.log(Level.SEVERE, new Throwable(m.toString()), m::toString);
            return m;
        }
        if (t == null) {
            NMsg m = NMsg.ofC("unexpected error : %s", "empty error message");
            LOG.log(Level.SEVERE, new Throwable(m.toString()), m::toString);
            return m;
        }
        return t;
    }

    public static String getNativePath(String s) {
        return s.replace('/', File.separatorChar);
    }
}

