/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;

public class NWorkspaceOptionsConfig {
    private boolean shortOptions;
    private boolean singleArgOptions;
    private boolean omitDefaults;
    private NVersion apiVersion;

    public NWorkspaceOptionsConfig setApiVersion(NVersion apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public NVersion getApiVersion() {
        return this.apiVersion;
    }

    public NWorkspaceOptionsConfig setCompact(boolean compact) {
        if (compact) {
            this.shortOptions = true;
            this.singleArgOptions = true;
            this.omitDefaults = true;
        } else {
            this.shortOptions = false;
            this.singleArgOptions = false;
            this.omitDefaults = false;
        }
        return this;
    }

    public boolean isShortOptions() {
        return this.shortOptions;
    }

    public boolean isSingleArgOptions() {
        return this.singleArgOptions;
    }

    public boolean isOmitDefaults() {
        return this.omitDefaults;
    }

    public int hashCode() {
        return Objects.hash(this.shortOptions, this.singleArgOptions, this.omitDefaults, this.apiVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NWorkspaceOptionsConfig that = (NWorkspaceOptionsConfig)o;
        return this.shortOptions == that.shortOptions && this.singleArgOptions == that.singleArgOptions && this.omitDefaults == that.omitDefaults && Objects.equals(this.apiVersion, that.apiVersion);
    }

    public String toString() {
        return "NutsWorkspaceOptionsConfig{, shortOptions=" + this.shortOptions + ", singleArgOptions=" + this.singleArgOptions + ", omitDefaults=" + this.omitDefaults + ", apiVersion=" + this.apiVersion + '}';
    }
}

