/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.io.Closeable;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NEnvContext;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.boot.core.NWorkspaceBase;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.command.NCustomCmd;
import net.thevpc.nuts.command.NInstallListener;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspaceBootConfig;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.core.NWorkspaceStoredConfig;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.internal.NScopedWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NDesktopIntegrationItem;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NLauncherOptions;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.spi.NIndexStoreFactory;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NObservableMapListener;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NSupportMode;

public interface NWorkspace
extends NWorkspaceBase,
NEnvContext,
NComponent,
Closeable {
    public static NWorkspace of() {
        return NWorkspace.get().get();
    }

    public static NOptional<NWorkspace> get() {
        return NScopedWorkspace.currentWorkspace();
    }

    public static void run(Runnable runnable) {
        NScopedWorkspace.runWith(runnable);
    }

    public static <T> T call(NCallable<T> callable) {
        return NScopedWorkspace.callWith(callable);
    }

    public NDescriptor resolveEffectiveDescriptor(NDescriptor var1, NDescriptorEffectiveConfig var2);

    public NDescriptor resolveEffectiveDescriptor(NDescriptor var1);

    public NWorkspace setSharedInstance();

    public NWorkspace share();

    public boolean isSharedInstance();

    public void runWith(Runnable var1);

    public <T> T callWith(NCallable<T> var1);

    public String getUuid();

    public String getName();

    public String getDigestName();

    public NVersion getApiVersion();

    public NVersion getBootVersion();

    public NId getApiId();

    public NId getAppId();

    public NId getRuntimeId();

    public NPath getLocation();

    public NSession createSession();

    public NSession currentSession();

    public NExtensions extensions();

    @Override
    public void close();

    public NWorkspace removeRepositoryListener(NRepositoryListener var1);

    public NWorkspace addRepositoryListener(NRepositoryListener var1);

    public List<NRepositoryListener> getRepositoryListeners();

    public NWorkspace addUserPropertyListener(NObservableMapListener<String, Object> var1);

    public NWorkspace removeUserPropertyListener(NObservableMapListener<String, Object> var1);

    public List<NObservableMapListener<String, Object>> getUserPropertyListeners();

    public NWorkspace removeWorkspaceListener(NWorkspaceListener var1);

    public NWorkspace addWorkspaceListener(NWorkspaceListener var1);

    public List<NWorkspaceListener> getWorkspaceListeners();

    public NWorkspace removeInstallListener(NInstallListener var1);

    public NWorkspace addInstallListener(NInstallListener var1);

    public List<NInstallListener> getInstallListeners();

    public NRepository addRepository(NAddRepositoryOptions var1);

    public NRepository addRepository(String var1);

    public NOptional<NRepository> findRepositoryById(String var1);

    public NOptional<NRepository> findRepositoryByName(String var1);

    public NOptional<NRepository> findRepository(String var1);

    public NWorkspace removeRepository(String var1);

    public List<NRepository> getRepositories();

    public NWorkspace removeAllRepositories();

    public Map<String, Object> getProperties();

    public NOptional<Object> getProperty(String var1);

    public <T> NOptional<T> getProperty(Class<T> var1);

    public NWorkspace setProperty(String var1, Object var2);

    public <T> T getOrComputeProperty(Class<T> var1, Supplier<T> var2);

    public <T> T getOrComputeProperty(String var1, Supplier<T> var2);

    public String getHostName();

    public String getPid();

    @Override
    public NOsFamily getOsFamily();

    @Override
    public Set<NShellFamily> getShellFamilies();

    @Override
    public NShellFamily getShellFamily();

    @Override
    public NId getDesktopEnvironment();

    @Override
    public Set<NId> getDesktopEnvironments();

    @Override
    public NDesktopEnvironmentFamily getDesktopEnvironmentFamily();

    @Override
    public Set<NDesktopEnvironmentFamily> getDesktopEnvironmentFamilies();

    @Override
    public NId getPlatform();

    @Override
    public NId getOs();

    @Override
    public NId getOsDist();

    @Override
    public NId getArch();

    @Override
    public NArchFamily getArchFamily();

    @Override
    public boolean isGraphicalDesktopEnvironment();

    @Override
    public NSupportMode getDesktopIntegrationSupport(NDesktopIntegrationItem var1);

    public Path getDesktopPath();

    public void addLauncher(NLauncherOptions var1);

    public List<String> buildEffectiveCommand(String[] var1, NRunAs var2, Set<NDesktopEnvironmentFamily> var3, Function<String, String> var4, Boolean var5, String var6, String var7, String[] var8);

    public NPath getHomeLocation(NStoreType var1);

    public NPath getStoreLocation(NStoreType var1);

    public NPath getStoreLocation(NId var1, NStoreType var2);

    public NPath getStoreLocation(NStoreType var1, String var2);

    public NPath getStoreLocation(NId var1, NStoreType var2, String var3);

    public NPath getStoreLocation(NLocationKey var1);

    public NStoreStrategy getStoreStrategy();

    public NWorkspace setStoreStrategy(NStoreStrategy var1);

    public NStoreStrategy getRepositoryStoreStrategy();

    public NOsFamily getStoreLayout();

    public NWorkspace setStoreLayout(NOsFamily var1);

    public Map<NStoreType, String> getStoreLocations();

    public String getDefaultIdFilename(NId var1);

    public NPath getDefaultIdBasedir(NId var1);

    public String getDefaultIdContentExtension(String var1);

    public String getDefaultIdExtension(NId var1);

    public Map<NHomeLocation, String> getHomeLocations();

    public NPath getHomeLocation(NHomeLocation var1);

    public NPath getWorkspaceLocation();

    public NWorkspace setStoreLocation(NStoreType var1, String var2);

    public NWorkspace setHomeLocation(NHomeLocation var1, String var2);

    public boolean addPlatform(NPlatformLocation var1);

    public boolean updatePlatform(NPlatformLocation var1, NPlatformLocation var2);

    public boolean removePlatform(NPlatformLocation var1);

    public NOptional<NPlatformLocation> findPlatformByName(NPlatformFamily var1, String var2);

    public NOptional<NPlatformLocation> findPlatformByPath(NPlatformFamily var1, NPath var2);

    public NOptional<NPlatformLocation> findPlatformByVersion(NPlatformFamily var1, String var2);

    public NOptional<NPlatformLocation> findPlatform(NPlatformLocation var1);

    public NOptional<NPlatformLocation> findPlatformByVersion(NPlatformFamily var1, NVersionFilter var2);

    public NStream<NPlatformLocation> searchSystemPlatforms(NPlatformFamily var1);

    public NStream<NPlatformLocation> searchSystemPlatforms(NPlatformFamily var1, NPath var2);

    public NOptional<NPlatformLocation> resolvePlatform(NPlatformFamily var1, NPath var2, String var3);

    public NOptional<NPlatformLocation> findPlatform(NPlatformFamily var1, Predicate<NPlatformLocation> var2);

    public NStream<NPlatformLocation> findPlatforms(NPlatformFamily var1, Predicate<NPlatformLocation> var2);

    public NStream<NPlatformLocation> findPlatforms();

    public NStream<NPlatformLocation> findPlatforms(NPlatformFamily var1);

    public NWorkspace addDefaultPlatforms(NPlatformFamily var1);

    public NWorkspace addDefaultPlatform(NPlatformFamily var1);

    public NOptional<String> findSysCommand(String var1);

    @Override
    public NOptional<String> getSysEnv(String var1);

    @Override
    public Map<String, String> getSysEnv();

    public NWorkspace addImports(String ... var1);

    public NWorkspace clearImports();

    public NWorkspace removeImports(String ... var1);

    public NWorkspace updateImports(String[] var1);

    public Set<String> getAllImports();

    public boolean isImportedGroupId(String var1);

    public NWorkspaceStoredConfig getStoredConfig();

    public boolean isReadOnly();

    public boolean saveConfig(boolean var1);

    public boolean saveConfig();

    public NWorkspaceBootConfig loadBootConfig(String var1, boolean var2, boolean var3);

    public boolean isSupportedRepositoryType(String var1);

    public List<NAddRepositoryOptions> getDefaultRepositories();

    public Set<String> getAvailableArchetypes();

    public NPath resolveRepositoryPath(String var1);

    public NIndexStoreFactory getIndexStoreClientFactory();

    public String getJavaCommand();

    public String getJavaOptions();

    public boolean isSystemWorkspace();

    public Map<String, String> getConfigMap();

    public NOptional<NLiteral> getConfigProperty(String var1);

    public NWorkspace setConfigProperty(String var1, String var2);

    public List<NCommandFactoryConfig> getCommandFactories();

    public void addCommandFactory(NCommandFactoryConfig var1);

    public void removeCommandFactory(String var1);

    public boolean removeCommandFactoryIfExists(String var1);

    public boolean commandExists(String var1);

    public boolean commandFactoryExists(String var1);

    public boolean addCommand(NCommandConfig var1);

    public boolean updateCommand(NCommandConfig var1);

    public void removeCommand(String var1);

    public boolean removeCommandIfExists(String var1);

    public NCustomCmd findCommand(String var1, NId var2, NId var3);

    public NCustomCmd findCommand(String var1);

    public List<NCustomCmd> findAllCommands();

    public List<NCustomCmd> findCommandsByOwner(NId var1);

    public boolean isFirstBoot();

    public NOptional<NLiteral> getCustomBootOption(String ... var1);

    public NBootOptions getBootOptions();

    public ClassLoader getBootClassLoader();

    public List<URL> getBootClassWorldURLs();

    public List<String> getBootRepositories();

    public Instant getCreationStartTime();

    public Instant getCreationFinishTime();

    public NDuration getCreationDuration();

    public NClassLoaderNode getBootRuntimeClassLoaderNode();

    public List<NClassLoaderNode> getBootExtensionClassLoaderNode();

    public NWorkspaceTerminalOptions getBootTerminal();
}

