/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.util.Objects;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public class NRunAs {
    public static final NRunAs CURRENT_USER = new NRunAs(Mode.CURRENT_USER, null);
    public static final NRunAs ROOT = new NRunAs(Mode.ROOT, null);
    public static final NRunAs SUDO = new NRunAs(Mode.SUDO, null);
    private final Mode mode;
    private final String user;

    private NRunAs(Mode mode, String user) {
        this.mode = mode;
        this.user = user;
    }

    public static NRunAs currentUser() {
        return CURRENT_USER;
    }

    public static NRunAs root() {
        return ROOT;
    }

    public static NRunAs sudo() {
        return SUDO;
    }

    public static NRunAs user(String name) {
        if (NBlankable.isBlank(name)) {
            throw new IllegalArgumentException("invalid user name");
        }
        return new NRunAs(Mode.SUDO, name);
    }

    public static NOptional<NRunAs> parse(String runAs) {
        String urunAs;
        if (NBlankable.isBlank(runAs)) {
            return NOptional.ofNamedEmpty("NRunAs " + runAs);
        }
        runAs = runAs.trim();
        switch (urunAs = runAs.toUpperCase()) {
            case "ROOT": 
            case "RUN-AS:ROOT": 
            case "RUN_AS:ROOT": {
                return NOptional.of(ROOT);
            }
            case "CURRENT_USER": 
            case "RUN-AS:CURRENT_USER": 
            case "RUN_AS:CURRENT_USER": {
                return NOptional.of(CURRENT_USER);
            }
            case "SUDO": 
            case "RUN-AS:SUDO": 
            case "RUN_AS:SUDO": {
                return NOptional.of(SUDO);
            }
        }
        if (urunAs.startsWith("RUN-AS:")) {
            return NOptional.of(NRunAs.user(runAs.substring("RUN-AS:".length())));
        }
        return NOptional.ofNamedEmpty("NRunAs " + runAs);
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRunAs nRunAs = (NRunAs)o;
        return this.mode == nRunAs.mode && Objects.equals(this.user, nRunAs.user);
    }

    public String toString() {
        switch (this.mode.ordinal()) {
            case 0: {
                return "run-as:current-user";
            }
            case 3: {
                return "run-as:sudo";
            }
            case 2: {
                return "run-as:root";
            }
            case 1: {
                return "run-as:" + this.user;
            }
        }
        return "run-as:" + this.mode + " , user='" + this.user + '\'';
    }

    public static enum Mode implements NEnum
    {
        CURRENT_USER,
        USER,
        ROOT,
        SUDO;

        private final String id = NNameFormat.ID_NAME.format(this.name());

        public static NOptional<Mode> parse(String value) {
            return NEnumUtils.parseEnum(value, Mode.class);
        }

        @Override
        public String id() {
            return this.id;
        }
    }
}

