/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.util.Objects;
import net.thevpc.nuts.core.NConfigItem;

public class NRepositoryRef
extends NConfigItem
implements Cloneable {
    private static final long serialVersionUID = 2L;
    private String name;
    private String location;
    private boolean enabled = true;
    private boolean failSafe = false;
    private int deployWeight;

    public NRepositoryRef() {
    }

    public NRepositoryRef(NRepositoryRef other) {
        this.name = other.getName();
        this.location = other.getLocation();
        this.enabled = other.isEnabled();
        this.failSafe = other.isEnabled();
        this.deployWeight = other.getDeployWeight();
    }

    public NRepositoryRef(String name, String location, int deployPriority, boolean enabled) {
        this.name = name;
        this.location = location;
        this.deployWeight = deployPriority;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NRepositoryRef setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public NRepositoryRef setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NRepositoryRef setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isFailSafe() {
        return this.failSafe;
    }

    public NRepositoryRef setFailSafe(boolean failSafe) {
        this.failSafe = failSafe;
        return this;
    }

    public NRepositoryRef copy() {
        return this.clone();
    }

    protected NRepositoryRef clone() {
        try {
            return (NRepositoryRef)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getDeployWeight() {
        return this.deployWeight;
    }

    public NRepositoryRef setDeployWeight(int deployPriority) {
        this.deployWeight = deployPriority;
        return this;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.name);
        hash = 79 * hash + Objects.hashCode(this.location);
        hash = 79 * hash + this.deployWeight;
        hash = 79 * hash + (this.enabled ? 1 : 0);
        hash = 79 * hash + (this.failSafe ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NRepositoryRef other = (NRepositoryRef)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.failSafe != other.failSafe) {
            return false;
        }
        if (this.deployWeight != other.deployWeight) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.location, other.location);
    }

    public String toString() {
        return "NutsRepositoryRef{name=" + this.name + ", location=" + this.location + ", enabled=" + this.enabled + ", failSafe=" + this.failSafe + ", deployPriority=" + this.deployWeight + '}';
    }
}

