/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NConfigItem;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.spi.NRepositoryLocation;

public class NRepositoryConfig
extends NConfigItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String uuid;
    private String name;
    private NRepositoryLocation location;
    private Map<NStoreType, String> storeLocations = null;
    private NStoreStrategy storeStrategy = null;
    private String groups;
    private Map<String, String> env;
    private List<NRepositoryRef> mirrors;
    private List<NUserConfig> users;
    private boolean indexEnabled;
    private String authenticationAgent;
    private String[] tags;

    public NRepositoryConfig copy() {
        return this.clone();
    }

    protected NRepositoryConfig clone() {
        try {
            NRepositoryConfig o = (NRepositoryConfig)super.clone();
            if (o.location != null) {
                o.location = o.location.copy();
            }
            if (o.storeLocations != null) {
                o.storeLocations = new LinkedHashMap<NStoreType, String>(this.storeLocations);
            }
            if (o.env != null) {
                o.env = new LinkedHashMap<String, String>(o.env);
            }
            if (o.mirrors != null) {
                o.mirrors = o.mirrors.stream().map(NRepositoryRef::copy).collect(Collectors.toList());
            }
            if (o.users != null) {
                o.users = o.users.stream().map(NUserConfig::copy).collect(Collectors.toList());
            }
            if (o.tags != null) {
                o.tags = Arrays.copyOf(this.tags, this.tags.length);
            }
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getTags() {
        return this.tags;
    }

    public NRepositoryConfig setTags(String[] tags) {
        this.tags = tags;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NRepositoryConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public NRepositoryConfig setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public NRepositoryLocation getLocation() {
        return this.location;
    }

    public NRepositoryConfig setLocation(NRepositoryLocation location) {
        this.location = location;
        return this;
    }

    public NStoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public NRepositoryConfig setStoreStrategy(NStoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    public String getGroups() {
        return this.groups;
    }

    public NRepositoryConfig setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public NRepositoryConfig setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public List<NRepositoryRef> getMirrors() {
        return this.mirrors;
    }

    public NRepositoryConfig setMirrors(List<NRepositoryRef> mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    public List<NUserConfig> getUsers() {
        return this.users;
    }

    public NRepositoryConfig setUsers(List<NUserConfig> users) {
        this.users = users;
        return this;
    }

    public boolean isIndexEnabled() {
        return this.indexEnabled;
    }

    public NRepositoryConfig setIndexEnabled(boolean indexEnabled) {
        this.indexEnabled = indexEnabled;
        return this;
    }

    public String getAuthenticationAgent() {
        return this.authenticationAgent;
    }

    public NRepositoryConfig setAuthenticationAgent(String authenticationAgent) {
        this.authenticationAgent = authenticationAgent;
        return this;
    }

    public Map<NStoreType, String> getStoreLocations() {
        return this.storeLocations;
    }

    public NRepositoryConfig setStoreLocations(Map<NStoreType, String> storeLocations) {
        this.storeLocations = storeLocations;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.uuid);
        hash = 53 * hash + Objects.hashCode(this.name);
        hash = 53 * hash + Objects.hashCode(this.location);
        hash = 53 * hash + Objects.hashCode(this.storeLocations);
        hash = 53 * hash + Objects.hashCode(this.storeStrategy);
        hash = 53 * hash + Objects.hashCode(this.groups);
        hash = 53 * hash + Objects.hashCode(this.env);
        hash = 53 * hash + Objects.hashCode(this.mirrors);
        hash = 53 * hash + Objects.hashCode(this.users);
        hash = 53 * hash + (this.indexEnabled ? 1 : 0);
        hash = 53 * hash + Objects.hashCode(this.authenticationAgent);
        hash = 53 * hash + Arrays.hashCode(this.tags);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NRepositoryConfig other = (NRepositoryConfig)obj;
        if (this.indexEnabled != other.indexEnabled) {
            return false;
        }
        if (!Objects.equals(this.uuid, other.uuid)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.groups, other.groups)) {
            return false;
        }
        if (!Objects.equals(this.authenticationAgent, other.authenticationAgent)) {
            return false;
        }
        if (!Objects.equals(this.storeLocations, other.storeLocations)) {
            return false;
        }
        if (this.storeStrategy != other.storeStrategy) {
            return false;
        }
        if (!Objects.equals(this.env, other.env)) {
            return false;
        }
        if (!Objects.equals(this.mirrors, other.mirrors)) {
            return false;
        }
        if (!Arrays.equals(this.tags, other.tags)) {
            return false;
        }
        return Objects.equals(this.users, other.users);
    }

    public String toString() {
        return "NutsRepositoryConfig{, uuid=" + this.uuid + ", name=" + this.name + ", location=" + this.location + ", storeLocations=" + (this.storeLocations == null ? "null" : this.storeLocations.toString()) + ", storeStrategy=" + this.storeStrategy + ", groups=" + this.groups + ", env=" + this.env + ", mirrors=" + this.mirrors + ", users=" + this.users + ", indexEnabled=" + this.indexEnabled + ", authenticationAgent=" + this.authenticationAgent + ", tags=" + (this.tags == null ? "[]" : Arrays.toString(this.tags)) + '}';
    }
}

