/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.io.Serializable;
import java.util.Objects;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NRepositoryModel;

public class NAddRepositoryOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int ORDER_USER_LOCAL = 1000;
    public static final int ORDER_SYSTEM_LOCAL = 2000;
    public static final int ORDER_USER_REMOTE = 10000;
    private String name;
    private String location;
    private boolean enabled = true;
    private boolean failSafe;
    private boolean create;
    private boolean temporary;
    private int deployWeight;
    private NRepositoryConfig config;
    private NRepositoryModel repositoryModel;
    private int order;

    public NAddRepositoryOptions() {
    }

    public NAddRepositoryOptions(NAddRepositoryOptions other) {
        this.name = other.name;
        this.location = other.location;
        this.enabled = other.enabled;
        this.failSafe = other.failSafe;
        this.create = other.create;
        this.temporary = other.temporary;
        this.deployWeight = other.deployWeight;
        this.order = other.order;
        this.config = other.config == null ? null : other.config.copy();
        this.repositoryModel = other.repositoryModel == null ? null : other.repositoryModel;
    }

    public NAddRepositoryOptions copy() {
        return this.clone();
    }

    protected NAddRepositoryOptions clone() {
        try {
            NAddRepositoryOptions o = (NAddRepositoryOptions)super.clone();
            o.config = o.config == null ? null : o.config.copy();
            o.repositoryModel = o.repositoryModel == null ? null : o.repositoryModel;
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public NRepositoryModel getRepositoryModel() {
        return this.repositoryModel;
    }

    public NAddRepositoryOptions setRepositoryModel(NRepositoryModel repositoryModel) {
        this.repositoryModel = repositoryModel;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public NAddRepositoryOptions setOrder(int order) {
        this.order = order;
        return this;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public NAddRepositoryOptions setTemporary(boolean value) {
        this.temporary = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NAddRepositoryOptions setName(String value) {
        this.name = value;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public NAddRepositoryOptions setLocation(String value) {
        this.location = value;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NAddRepositoryOptions setEnabled(boolean value) {
        this.enabled = value;
        return this;
    }

    public boolean isFailSafe() {
        return this.failSafe;
    }

    public NAddRepositoryOptions setFailSafe(boolean value) {
        this.failSafe = value;
        return this;
    }

    public boolean isCreate() {
        return this.create;
    }

    public NAddRepositoryOptions setCreate(boolean value) {
        this.create = value;
        return this;
    }

    public NRepositoryConfig getConfig() {
        return this.config;
    }

    public NAddRepositoryOptions setConfig(NRepositoryConfig value) {
        this.config = value;
        return this;
    }

    public int getDeployWeight() {
        return this.deployWeight;
    }

    public NAddRepositoryOptions setDeployWeight(int value) {
        this.deployWeight = value;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.location, this.enabled, this.failSafe, this.create, this.temporary, this.order, this.deployWeight, this.config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NAddRepositoryOptions that = (NAddRepositoryOptions)o;
        return this.enabled == that.enabled && this.failSafe == that.failSafe && this.create == that.create && this.temporary == that.temporary && this.order == that.order && this.deployWeight == that.deployWeight && Objects.equals(this.name, that.name) && Objects.equals(this.location, that.location) && Objects.equals(this.config, that.config);
    }

    public String toString() {
        return "NutsAddRepositoryOptions{name='" + this.name + '\'' + ", location='" + this.location + '\'' + ", enabled=" + this.enabled + ", failSafe=" + this.failSafe + ", create=" + this.create + ", temporary=" + this.temporary + ", deployOrder=" + this.deployWeight + ", order=" + this.order + ", config=" + this.config + '}';
    }
}

