/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NCallable;

public class NScopedStack<T> {
    private InheritableThreadLocal<Stack<T>> holder = new InheritableThreadLocal();
    private Supplier<T> defaultSupplier;

    public NScopedStack(Supplier<T> defaultSupplier) {
        this.defaultSupplier = defaultSupplier;
    }

    public T get() {
        Stack s = (Stack)this.holder.get();
        T h = null;
        if (s != null && (h = (T)s.peek()) != null) {
            return h;
        }
        if (this.defaultSupplier != null) {
            h = this.defaultSupplier.get();
        }
        return h;
    }

    public NScopedStack<T> setDefaultSupplier(Supplier<T> defaultSupplier) {
        this.defaultSupplier = defaultSupplier;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runWith(T value, Runnable r) {
        if (value == null) {
            if (r == null) return;
            r.run();
            return;
        }
        Stack<T> s = (Stack<T>)this.holder.get();
        if (s != null && !s.isEmpty()) {
            Object old = s.peek();
            if (old == value) {
                if (r == null) return;
                r.run();
                return;
            } else {
                s.push(value);
                try {
                    if (r == null) return;
                    r.run();
                    return;
                }
                finally {
                    s.pop();
                    if (s.isEmpty()) {
                        this.holder.remove();
                    }
                }
            }
        }
        if (s == null) {
            s = new Stack<T>();
            this.holder.set(s);
        }
        s.push(value);
        try {
            if (r == null) return;
            r.run();
            return;
        }
        finally {
            s.pop();
            if (s.isEmpty()) {
                this.holder.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V callWith(T value, NCallable<V> c) {
        if (value == null) {
            if (c != null) {
                return c.call();
            }
            return null;
        }
        Stack<T> s = (Stack<T>)this.holder.get();
        if (s != null && !s.isEmpty()) {
            Object old = s.peek();
            if (old == value) {
                if (c != null) {
                    return c.call();
                }
                return null;
            }
            s.push(value);
            try {
                if (c != null) {
                    V v = c.call();
                    return v;
                }
                V v = null;
                return v;
            }
            finally {
                s.pop();
                if (s.isEmpty()) {
                    this.holder.remove();
                }
            }
        }
        if (s == null) {
            s = new Stack<T>();
            this.holder.set(s);
        }
        s.push(value);
        try {
            if (c != null) {
                V v = c.call();
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            s.pop();
            if (s.isEmpty()) {
                this.holder.remove();
            }
        }
    }

    public boolean isEmpty() {
        Stack s = (Stack)this.holder.get();
        return s == null || s.isEmpty();
    }

    public int depth() {
        Stack s = (Stack)this.holder.get();
        return s == null ? 0 : s.size();
    }

    public List<T> getStackSnapshot() {
        Stack s = (Stack)this.holder.get();
        return s == null ? Collections.emptyList() : new ArrayList(s);
    }

    public T peek(int levelFromTop) {
        Stack s = (Stack)this.holder.get();
        if (s == null || s.isEmpty()) {
            return null;
        }
        int index = s.size() - 1 - levelFromTop;
        return index >= 0 ? (T)s.get(index) : null;
    }
}

