/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.concurrent.Future;
import java.util.function.IntFunction;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.elem.NElementDescribable;
import net.thevpc.nuts.time.NDuration;

public interface NRetryCall<T>
extends NCallable<T>,
NElementDescribable {
    public static <T> NRetryCall<T> of(NCallable<T> callable) {
        return NConcurrent.of().retryCall(callable);
    }

    public static <T> NRetryCall<T> of(String id, NCallable<T> callable) {
        return NConcurrent.of().retryCall(id, callable);
    }

    public NRetryCall<T> setMaxRetries(int var1);

    public NRetryCall<T> setRetryPeriod(IntFunction<NDuration> var1);

    public NRetryCall<T> setMultipliedRetryPeriod(NDuration var1, double var2);

    public NRetryCall<T> setExponentialRetryPeriod(NDuration var1, double var2);

    public NRetryCall<T> setRetryPeriod(NDuration var1);

    public NRetryCall<T> setRetryPeriods(NDuration ... var1);

    public NRetryCall<T> setRecover(NCallable<T> var1);

    public NRetryCall<T> setHandler(Handler<T> var1);

    public T callOrElse(NCallable<T> var1);

    @Override
    public T call();

    public void callAsync();

    public Future<Result<T>> callFuture();

    public static interface Result<T> {
        public String id();

        public NRetryCall<T> value();

        public boolean isValid();

        public boolean isError();

        public T result();
    }

    public static interface Handler<T> {
        public void handle(Result<T> var1);
    }

    public static enum Status {
        CREATED,
        QUEUED,
        RUNNING,
        FAILED_ATTEMPT,
        RETRYING,
        SUCCEEDED,
        FAILED,
        CANCELLED,
        HANDLING,
        HANDLED,
        HANDLER_FAILED,
        HANDLER_SUCCEEDED;

    }
}

