/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribable;
import net.thevpc.nuts.elem.NUpletElementBuilder;

public class NRateLimitValueModel
implements Serializable,
NElementDescribable {
    private String id;
    private long lastAccess;
    private NRateLimitRuleModel[] rules;

    public NRateLimitValueModel(String id, long lastAccess, NRateLimitRuleModel[] rules) {
        this.id = id == null ? "" : id;
        this.lastAccess = lastAccess;
        this.rules = rules;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public NRateLimitRuleModel[] getRules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRateLimitValueModel that = (NRateLimitValueModel)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.lastAccess, that.lastAccess) && Objects.deepEquals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastAccess, Arrays.hashCode(this.rules));
    }

    public String toString() {
        return "NLimitedValueData{id='" + this.id + '\'' + ", lastAccess=" + this.lastAccess + ", rules=" + Arrays.toString(this.rules) + '}';
    }

    @Override
    public NElement describe() {
        NUpletElementBuilder b = NElement.ofUpletBuilder("RateLimitValue").add("id", this.id);
        if (this.lastAccess > 0L) {
            b.add("lastAccess", this.lastAccess);
        }
        if (this.rules != null && this.rules.length > 0) {
            b.add("rules", (NElement)NElement.ofArray((NElement[])Arrays.stream(this.rules).map(NRateLimitRuleModel::describe).toArray(NElement[]::new)));
        }
        return b.build();
    }
}

