/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.command;

import java.util.Objects;

public class NInstallStatus {
    private static final NInstallStatus[] ALL = NInstallStatus._buildNutsInstallStatusArray();
    public static final NInstallStatus NONE = NInstallStatus.of(false, false, false, false, false);
    public static final NInstallStatus REQUIRED = NInstallStatus.of(false, false, true, false, false);
    private final boolean deployed;
    private final boolean installed;
    private final boolean required;
    private final boolean obsolete;
    private final boolean defaultVersion;

    private NInstallStatus(boolean deployed, boolean installed, boolean required, boolean obsolete, boolean defaultVersion) {
        this.deployed = deployed;
        this.installed = installed;
        this.required = required;
        this.obsolete = obsolete;
        this.defaultVersion = defaultVersion;
    }

    private static NInstallStatus[] _buildNutsInstallStatusArray() {
        NInstallStatus[] ALL = new NInstallStatus[32];
        for (int i = 0; i < 32; ++i) {
            ALL[i] = new NInstallStatus((i & 1) != 0, (i & 1) != 0, (i & 2) != 0, (i & 4) != 0, (i & 8) != 0);
        }
        return ALL;
    }

    public static NInstallStatus of(boolean deployed, boolean installed, boolean required, boolean obsolete, boolean defaultVersion) {
        return ALL[(deployed ? 1 : 0) * 1 + (installed ? 1 : 0) * 2 + (required ? 1 : 0) * 4 + (obsolete ? 1 : 0) * 8 + (defaultVersion ? 1 : 0) * 16];
    }

    public boolean isNonDeployed() {
        return !this.isInstalled() && !this.isRequired();
    }

    public boolean isInstalledOrRequired() {
        return this.isInstalled() || this.isRequired();
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public NInstallStatus withInstalled(boolean installed) {
        return NInstallStatus.of(this.deployed, installed, this.required, this.obsolete, this.defaultVersion);
    }

    public NInstallStatus withDeployed(boolean deployed) {
        return NInstallStatus.of(deployed, this.installed, this.required, this.obsolete, this.defaultVersion);
    }

    public NInstallStatus withRequired(boolean required) {
        return NInstallStatus.of(this.deployed, this.installed, required, this.obsolete, this.defaultVersion);
    }

    public NInstallStatus withObsolete(boolean obsolete) {
        return NInstallStatus.of(this.deployed, this.installed, this.required, obsolete, this.defaultVersion);
    }

    public NInstallStatus withDefaultVersion(boolean defaultVersion) {
        return NInstallStatus.of(this.deployed, this.installed, this.required, this.obsolete, defaultVersion);
    }

    public int hashCode() {
        return Objects.hash(this.deployed, this.installed, this.required, this.obsolete, this.defaultVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NInstallStatus that = (NInstallStatus)o;
        return this.deployed == that.deployed && this.installed == that.installed && this.required == that.required && this.obsolete == that.obsolete && this.defaultVersion == that.defaultVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.installed) {
            sb.append("installed");
        }
        if (this.deployed) {
            sb.append("deployed");
        }
        if (this.required) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("required");
        }
        if (this.defaultVersion) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("defaultVersion");
        }
        if (this.obsolete) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("obsolete");
        }
        if (sb.length() == 0) {
            sb.append("not-deployed");
        }
        return sb.toString();
    }
}

