/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.command;

import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NException;

public class NFetchModeNotSupportedException
extends NException {
    private final String id;
    private final String repositoryName;
    private final String repositoryUuid;
    private final NFetchMode fetchMode;

    public NFetchModeNotSupportedException(NRepository repo, NFetchMode fetchMode, String id, NMsg message, Exception cause) {
        super(message == null ? NMsg.ofC("unsupported fetch mode %s", fetchMode) : message, (Throwable)cause);
        this.id = id;
        this.repositoryName = repo == null ? null : repo.getName();
        this.repositoryUuid = repo == null ? null : repo.getUuid();
        this.fetchMode = fetchMode;
    }

    public NFetchModeNotSupportedException(NRepository repo, NFetchMode fetchMode, String id, NMsg message) {
        super(message == null ? NMsg.ofC("unsupported fetch mode %s", fetchMode) : message);
        this.id = id;
        this.repositoryName = repo == null ? null : repo.getName();
        this.repositoryUuid = repo == null ? null : repo.getUuid();
        this.fetchMode = fetchMode;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryUuid() {
        return this.repositoryUuid;
    }

    public NFetchMode getFetchMode() {
        return this.fetchMode;
    }

    public String getId() {
        return this.id;
    }
}

