/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.cmdline;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.thevpc.nuts.cmdline.DefaultNCmdLine;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NArgName;
import net.thevpc.nuts.cmdline.NArgType;
import net.thevpc.nuts.cmdline.NCmdLineAutoComplete;
import net.thevpc.nuts.cmdline.NCmdLineConfigurable;
import net.thevpc.nuts.cmdline.NCmdLineProcessor;
import net.thevpc.nuts.cmdline.NCmdLineRunner;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public interface NCmdLine
extends Iterable<NArg>,
NBlankable {
    public static NCmdLine ofArgs(String ... args) {
        if (NWorkspace.get().isNotPresent()) {
            return new DefaultNCmdLine(args, NShellFamily.getCurrent());
        }
        return NCmdLines.of().of(args);
    }

    public static NCmdLine of(String[] args) {
        return NCmdLine.ofArgs(args);
    }

    public static NCmdLine of(List<String> args) {
        return NCmdLine.ofArgs(args == null ? null : args.toArray(new String[0]));
    }

    public static NOptional<NCmdLine> parseDefault(String line) {
        if (NWorkspace.get().isNotPresent()) {
            return DefaultNCmdLine.parseDefaultList(line).map(args -> new DefaultNCmdLine((String[])args, NShellFamily.BASH));
        }
        return NCmdLines.of().setShellFamily(NShellFamily.BASH).parseCmdLine(line);
    }

    public static NOptional<NCmdLine> parse(String line) {
        if (NWorkspace.get().isNotPresent()) {
            return NCmdLine.parseDefault(line);
        }
        return NCmdLines.of().parseCmdLine(line);
    }

    public static NOptional<NCmdLine> parse(String line, NShellFamily shellFamily) {
        if (NWorkspace.get().isNotPresent()) {
            return NCmdLine.parseDefault(line);
        }
        return NCmdLines.of().setShellFamily(shellFamily).parseCmdLine(line);
    }

    public static NCmdLine of(String line, NShellFamily shellFamily) {
        return NCmdLine.parse(line, shellFamily).get();
    }

    public static NCmdLine of(String line) {
        return NCmdLine.parse(line).get();
    }

    public static NCmdLine ofDefault(String line) {
        return NCmdLine.parseDefault(line).get();
    }

    public Object getSource();

    public NCmdLine setSource(Object var1);

    public boolean isUnsafe();

    public NCmdLine setUnsafe(boolean var1);

    public NCmdLineConfigurable getConfigurable();

    public NCmdLine setConfigurable(NCmdLineConfigurable var1);

    public boolean isExpandArgumentsFile();

    public NCmdLine setExpandArgumentsFile(boolean var1);

    public NCmdLineAutoComplete getAutoComplete();

    public NCmdLine setAutoComplete(NCmdLineAutoComplete var1);

    public NCmdLine unregisterSpecialSimpleOption(String var1);

    public String[] getSpecialSimpleOptions();

    public NCmdLine registerSpecialSimpleOption(String var1);

    public boolean isSpecialSimpleOption(String var1);

    public int getWordIndex();

    public boolean isExecMode();

    public boolean isAutoCompleteMode();

    public String getCommandName();

    public NCmdLine setCommandName(String var1);

    public boolean isExpandSimpleOptions();

    public NCmdLine setExpandSimpleOptions(boolean var1);

    public NCmdLine throwUnexpectedArgument(NText var1);

    public NCmdLine throwUnexpectedArgument(NMsg var1);

    public NCmdLine throwMissingArgument();

    public NCmdLine throwMissingArgument(NMsg var1);

    public NCmdLine throwMissingArgument(String var1);

    public NCmdLine throwUnexpectedArgument();

    public NCmdLine pushBack(NArg var1);

    public NOptional<NArg> next();

    public NOptional<String> nextString();

    public NOptional<NArg> next(NArgName var1);

    public NOptional<NArg> nextOption(String var1);

    public NOptional<NArg> peek();

    public NOptional<NArg> peekNonOption();

    public NOptional<NArg> peekOption();

    public boolean isNextOption();

    public boolean isNextNonOption();

    public boolean hasNext();

    public boolean hasNextOption();

    public boolean hasNextNonOption();

    public NOptional<NArg> nextFlag(String ... var1);

    public NOptional<NArg> nextFlag();

    public NOptional<NArg> nextEntry(String ... var1);

    public Matcher matcher();

    public NOptional<NArg> nextEntry();

    public NOptional<NArg> next(String ... var1);

    public NOptional<NArg> next(NArgType var1, String ... var2);

    public NOptional<NArg> nextNonOption();

    public NOptional<NArg> nextNonOption(NArgName var1);

    public NOptional<NArg> nextNonOption(String var1);

    public int skipAll();

    public int skip();

    public int skip(int var1);

    public boolean accept(String ... var1);

    public boolean accept(int var1, String ... var2);

    public NOptional<NArg> find(String var1);

    public NOptional<NArg> get(int var1);

    public boolean contains(String var1);

    public int indexOf(String var1);

    public int length();

    public boolean isEmpty();

    public String[] toStringArray();

    public List<String> toStringList();

    public NArg[] toArgumentArray();

    public String[] nextAllAsStringArray();

    public List<String> nextAllAsStringList();

    public NArg[] nextAllAsArgumentArray();

    public boolean isOption(int var1);

    public boolean isNonOption(int var1);

    public NCmdLine setArguments(List<String> var1);

    public NCmdLine setArguments(String[] var1);

    public void throwError(NMsg var1);

    public void throwError(NText var1);

    public NCmdLine add(String var1);

    public NCmdLine addAll(List<String> var1);

    public void run(NCmdLineRunner var1);

    public NCmdLine pushBack(NArg ... var1);

    public NCmdLine pushBack(String ... var1);

    public NCmdLine append(String ... var1);

    @Override
    public Iterator<NArg> iterator();

    @Override
    default public void forEach(Consumer<? super NArg> action) {
        Iterable.super.forEach(action);
    }

    public NCmdLine forEachPeek(NCmdLineProcessor var1);

    public NCmdLine forEachPeek(NCmdLineProcessor ... var1);

    public NCmdLine copy();

    public NShellFamily getShellFamily();

    public NCmdLine setShellFamily(NShellFamily var1);

    public static interface MatcherCondition {
        public Matcher matchFlag(Consumer<NArg> var1);

        public MatcherCondition and(Predicate<NCmdLine> var1);

        public Matcher matchEntry(Consumer<NArg> var1);

        public Matcher matchAny(Consumer<NArg> var1);

        public Matcher skip();

        public Matcher matchAnyMultiple(Consumer<NCmdLine> var1);

        public Matcher matchTrueFlag(Consumer<NArg> var1);
    }

    public static interface Matcher {
        public Matcher matchAll(NCmdLineProcessor var1);

        public Matcher matchFlag(Consumer<NArg> var1);

        public Matcher matchEntry(Consumer<NArg> var1);

        public Matcher matchAny(Consumer<NArg> var1);

        public Matcher matchTrueFlag(Consumer<NArg> var1);

        public MatcherCondition withAny();

        public MatcherCondition with(String ... var1);

        public MatcherCondition withCondition(Predicate<NCmdLine> var1);

        public MatcherCondition withNonOption();

        public MatcherCondition withOption();

        public boolean anyMatch();

        public boolean noMatch();

        public void requireDefaults();

        public void require();

        public Matcher withDefaults();

        public Matcher withDefaultFirst();
    }
}

