/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.cmdline;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public class DefaultNArg
implements NArg {
    public static final String KEY_PATTERN_STRING = "[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]*";
    public static final Pattern PATTERN_OPTION_EQ = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]*)?(?<opts>[=](?<optv>.*))?(?<optr>.*)$");
    public static final Pattern PATTERN_OPTION_COL = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]*)?(?<opts>[:](?<optv>.*))?(?<optr>.*)$");
    private final char eq;
    private final String key;
    private final String value;
    private final String optionPrefix;
    private final String optionName;
    private final boolean enabled;
    private final boolean active;
    private final boolean option;
    private final String image;
    private final NCmdLine cmdLine;

    public static boolean isSimpleKey(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isKeyStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '@' || c == '&' || c == '^' || c == '$' || c == '%';
    }

    public static boolean isKeyPart(char c) {
        return DefaultNArg.isKeyStart(c) || c == '-' || c == '+' || c == '!';
    }

    public DefaultNArg(String expression) {
        this(expression, null);
    }

    public DefaultNArg(String expression, NCmdLine cmdLine) {
        this(expression, '=', cmdLine);
    }

    public DefaultNArg(String image, char eq) {
        this(image, eq, null);
    }

    public DefaultNArg(String image, char eq, NCmdLine cmdLine) {
        Pattern currOptionsPattern;
        this.cmdLine = cmdLine;
        this.eq = (char)(eq == '\u0000' ? 61 : (int)eq);
        this.image = image;
        switch (this.eq) {
            case '=': {
                currOptionsPattern = PATTERN_OPTION_EQ;
                break;
            }
            case ':': {
                currOptionsPattern = PATTERN_OPTION_COL;
                break;
            }
            default: {
                currOptionsPattern = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]**)?(?<opts>[" + eq + "](?<optv>.*))?(?<optr>.*)$");
            }
        }
        Matcher matcher = currOptionsPattern.matcher(image == null ? "" : image);
        if (matcher.find()) {
            String optp = matcher.group("optp");
            String cmt = matcher.group("cmt");
            String flg = matcher.group("flg");
            String optk = matcher.group("optk");
            String opts = matcher.group("opts");
            String optv = matcher.group("optv");
            String optr = matcher.group("optr");
            if (optp != null && optp.length() > 0) {
                this.option = true;
                this.active = cmt == null || cmt.length() <= 0;
                this.enabled = flg == null || flg.length() <= 0;
                this.optionPrefix = optp;
                if (optr != null && optr.length() > 0) {
                    this.optionName = (optk == null ? "" : optk) + optr;
                    this.key = optp + this.optionName;
                    this.value = null;
                } else {
                    String string = this.optionName = optk == null ? "" : optk;
                    if (opts != null && opts.length() > 0) {
                        this.key = optp + this.optionName;
                        this.value = optv + optr;
                    } else {
                        this.key = optp + this.optionName;
                        this.value = null;
                    }
                }
            } else {
                this.option = false;
                this.active = true;
                this.enabled = true;
                this.optionPrefix = null;
                this.optionName = null;
                if (opts != null && opts.length() > 0) {
                    this.key = image == null ? null : (optk == null ? "" : optk);
                    this.value = optv;
                } else {
                    this.key = image == null ? null : (optk == null ? "" : optk) + optr;
                    this.value = null;
                }
            }
        } else {
            this.active = true;
            this.enabled = true;
            this.option = false;
            this.optionName = null;
            this.key = null;
            this.value = null;
            this.optionPrefix = null;
        }
    }

    @Override
    public boolean isOption() {
        return this.option;
    }

    @Override
    public boolean isNonOption() {
        return !this.isOption();
    }

    @Override
    public NOptional<String> getStringKey() {
        return this.getKey().asString();
    }

    @Override
    public String key() {
        return this.getStringKey().orElse("");
    }

    @Override
    public String value() {
        return this.getStringValue().orNull();
    }

    @Override
    public NOptional<String> getStringValue() {
        return this.getValue().asString().ifEmptyUse(() -> NOptional.ofEmpty(() -> NMsg.ofC("missing value for : %s", this.getKey().asString().orElse("")))).ifErrorUse(() -> NOptional.ofEmpty(() -> NMsg.ofC("erroneous value for : %s", this.getKey().asString().orElse(""))));
    }

    @Override
    public NOptional<Integer> getIntValue() {
        return this.getValue().asInt();
    }

    @Override
    public NOptional<Long> getLongValue() {
        return this.getValue().asLong();
    }

    @Override
    public NOptional<Double> getDoubleValue() {
        return this.getValue().asDouble();
    }

    @Override
    public NOptional<Float> getFloatValue() {
        return this.getValue().asFloat();
    }

    @Override
    public NOptional<LocalDate> getLocalDateValue() {
        return this.getValue().asLocalDate();
    }

    @Override
    public NOptional<LocalTime> getLocalTimeValue() {
        return this.getValue().asLocalTime();
    }

    @Override
    public NOptional<LocalDateTime> getLocalDateTimeValue() {
        return this.getValue().asLocalDateTime();
    }

    @Override
    public NOptional<Instant> getInstantValue() {
        return this.getValue().asInstant();
    }

    @Override
    public int intValue() {
        return this.getIntValue().get();
    }

    @Override
    public double doubleValue() {
        return this.getDoubleValue().get();
    }

    @Override
    public float floatValue() {
        return this.getFloatValue().get().floatValue();
    }

    @Override
    public long longValue() {
        return this.getLongValue().get();
    }

    @Override
    public LocalDate localDateValue() {
        return this.getLocalDateValue().get();
    }

    @Override
    public LocalDateTime localTimeValue() {
        return this.getLocalDateTimeValue().get();
    }

    @Override
    public LocalDateTime localDateTimeValue() {
        return this.getLocalDateTimeValue().get();
    }

    @Override
    public Instant instantValue() {
        return this.getInstantValue().get();
    }

    @Override
    public NOptional<BigInteger> getBigIntValue() {
        return this.getValue().asBigInt();
    }

    @Override
    public BigInteger bigIntValue() {
        return this.getBigIntValue().get();
    }

    @Override
    public NOptional<BigDecimal> getBigDecimalValue() {
        return this.getValue().asBigDecimal();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.getBigDecimalValue().get();
    }

    @Override
    public String stringValue() {
        return this.getStringValue().get();
    }

    @Override
    public boolean isNegated() {
        return !this.enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isUncommented() {
        return this.active;
    }

    @Override
    public boolean isCommented() {
        return !this.active;
    }

    @Override
    public NArg required() {
        if (this.image == null) {
            throw NExceptions.ofSafeNoSuchElementException(NMsg.ofPlain("missing value"));
        }
        return this;
    }

    @Override
    public boolean isKeyValue() {
        return this.value != null;
    }

    @Override
    public NLiteral getOptionPrefix() {
        return NLiteral.of(this.optionPrefix);
    }

    @Override
    public String getSeparator() {
        return String.valueOf(this.eq);
    }

    @Override
    public NLiteral getOptionName() {
        return NLiteral.of(this.optionName);
    }

    @Override
    public NLiteral getValue() {
        return NLiteral.of(this.value);
    }

    @Override
    public NOptional<Boolean> getBooleanValue() {
        if (this.isNegated()) {
            return this.getValue().asBoolean().ifEmpty(true).map(x -> this.isNegated() != x.booleanValue()).ifEmptyUse(() -> NOptional.ofEmpty(() -> NMsg.ofC("missing value for : %s", this.getKey().asString().orElse("")))).ifErrorUse(() -> NOptional.ofEmpty(() -> NMsg.ofC("erroneous value for : %s", this.getKey().asString().orElse(""))));
        }
        return this.getValue().asBoolean().ifEmptyUse(() -> NOptional.ofEmpty(() -> NMsg.ofC("missing value for : %s", this.getKey().asString().orElse("")))).ifErrorUse(() -> NOptional.ofEmpty(() -> NMsg.ofC("erroneous value for : %s", this.getKey().asString().orElse(""))));
    }

    @Override
    public boolean booleanValue() {
        return this.getBooleanValue().get();
    }

    @Override
    public NLiteral getKey() {
        return NLiteral.of(this.key == null ? this.image : this.key);
    }

    @Override
    public boolean isFlagOption() {
        return this.isOption() && this.getValue().isNull();
    }

    public NLiteral toLiteral() {
        return NLiteral.of(this.image);
    }

    public String toString() {
        return String.valueOf(this.image);
    }

    @Override
    public String image() {
        return this.image;
    }

    public NOptional<Instant> asInstant() {
        return this.toLiteral().asInstant();
    }

    public NOptional<LocalDate> asLocalDate() {
        return this.toLiteral().asLocalDate();
    }

    public NOptional<LocalDateTime> asLocalDateTime() {
        return this.toLiteral().asLocalDateTime();
    }

    public NOptional<LocalTime> asLocalTime() {
        return this.toLiteral().asLocalTime();
    }

    public NOptional<NBigComplex> asBigComplex() {
        return this.toLiteral().asBigComplex();
    }

    public NOptional<NDoubleComplex> asDoubleComplex() {
        return this.toLiteral().asDoubleComplex();
    }

    public NOptional<NFloatComplex> asFloatComplex() {
        return this.toLiteral().asFloatComplex();
    }

    public NOptional<Number> asNumber() {
        return this.toLiteral().asNumber();
    }

    @Override
    public NOptional<Boolean> asBoolean() {
        return this.toLiteral().asBoolean();
    }

    @Override
    public NOptional<Long> asLong() {
        return this.toLiteral().asLong();
    }

    public NOptional<Double> asDouble() {
        return this.toLiteral().asDouble();
    }

    public NOptional<Float> asFloat() {
        return this.toLiteral().asFloat();
    }

    public NOptional<Byte> asByte() {
        return this.toLiteral().asByte();
    }

    public NOptional<Short> asShort() {
        return this.toLiteral().asShort();
    }

    @Override
    public NOptional<Integer> asInt() {
        return this.toLiteral().asInt();
    }

    public NOptional<BigInteger> asBigInt() {
        return this.toLiteral().asBigInt();
    }

    public NOptional<BigDecimal> asBigDecimal() {
        return this.toLiteral().asBigDecimal();
    }

    @Override
    public boolean isBoolean() {
        return this.toLiteral().asBoolean().isPresent();
    }

    public boolean isString() {
        return this.toLiteral().asString().isPresent();
    }

    public boolean isComplexNumber() {
        return this.toLiteral().isComplexNumber();
    }

    public boolean isTemporal() {
        NLiteral t = this.toLiteral();
        return t.asLocalDate().isPresent() || t.asLocalDateTime().isPresent() || t.asLocalTime().isPresent() || t.asInstant().isPresent();
    }

    public boolean isLocalTemporal() {
        NLiteral t = this.toLiteral();
        return t.asLocalDate().isPresent() || t.asLocalDateTime().isPresent() || t.asLocalTime().isPresent();
    }

    public boolean isNull() {
        return this.toLiteral().isNull();
    }

    public boolean isByte() {
        return this.toLiteral().asByte().isPresent();
    }

    public boolean isDecimalNumber() {
        return this.toLiteral().asBigDecimal().isPresent();
    }

    public boolean isBigNumber() {
        return this.toLiteral().asBigDecimal().isPresent();
    }

    public boolean isBigDecimal() {
        return this.toLiteral().asBigDecimal().isPresent();
    }

    public boolean isBigInt() {
        return this.toLiteral().asBigInt().isPresent();
    }

    @Override
    public boolean isInt() {
        return this.toLiteral().asInt().isPresent();
    }

    @Override
    public boolean isLong() {
        return this.toLiteral().asLong().isPresent();
    }

    public boolean isShort() {
        return this.toLiteral().asShort().isPresent();
    }

    public boolean isFloat() {
        return this.toLiteral().asFloat().isPresent();
    }

    public boolean isDouble() {
        return this.toLiteral().asDouble().isPresent();
    }

    public boolean isInstant() {
        return this.toLiteral().asInstant().isPresent();
    }

    public boolean isEmpty() {
        return this.toLiteral().isEmpty();
    }

    @Override
    public boolean isBlank() {
        return this.toLiteral().isBlank();
    }

    public boolean isNumber() {
        return this.toLiteral().asNumber().isPresent();
    }

    @Override
    public NOptional<String> asString() {
        return this.toLiteral().asString();
    }

    public String toStringLiteral() {
        return this.toLiteral().toStringLiteral();
    }

    public NOptional<Character> asChar() {
        return this.toLiteral().asChar();
    }

    public boolean isSupportedType(Class<?> type) {
        return this.toLiteral().isSupportedType(type);
    }

    public <ET> NOptional<ET> asType(Class<ET> expectedType) {
        return this.toLiteral().asType(expectedType);
    }

    public <ET> NOptional<ET> asType(Type expectedType) {
        return this.toLiteral().asType(expectedType);
    }

    public NOptional<String> asStringAt(int index) {
        return this.toLiteral().asStringAt(index);
    }

    public NOptional<Long> asLongAt(int index) {
        return this.toLiteral().asLongAt(index);
    }

    public NOptional<Integer> asIntAt(int index) {
        return this.toLiteral().asIntAt(index);
    }

    public NOptional<Double> asDoubleAt(int index) {
        return this.toLiteral().asDoubleAt(index);
    }

    public boolean isNullAt(int index) {
        return this.toLiteral().isNullAt(index);
    }

    public NLiteral asLiteralAt(int index) {
        return this.toLiteral().asLiteralAt(index);
    }

    public NOptional<Object> asObjectAt(int index) {
        return this.toLiteral().asObjectAt(index);
    }

    public boolean isStream() {
        return this.toLiteral().isStream();
    }

    public boolean isOrdinalNumber() {
        return this.toLiteral().asBigInt().isPresent();
    }

    public boolean isFloatingNumber() {
        return this.toLiteral().asBigDecimal().isPresent();
    }

    @Override
    public NCmdLine getCommandLine() {
        return this.cmdLine;
    }
}

