/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootPlatformHome {
    public static final NBootPlatformHome USER = NBootPlatformHome.of(null);
    public static final NBootPlatformHome SYSTEM = NBootPlatformHome.ofSystem(null);
    private final String platformOsFamily;
    private final boolean system;
    private final Function<String, String> env;
    private final Function<String, String> props;
    private final String sysPrefix = "system";

    public static NBootPlatformHome ofSystem(String platformOsFamily, Function<String, String> env, Function<String, String> props) {
        return new NBootPlatformHome(platformOsFamily, true, env, props);
    }

    public static NBootPlatformHome of(String platformOsFamily, Function<String, String> env, Function<String, String> props) {
        return new NBootPlatformHome(platformOsFamily, false, env, props);
    }

    public static NBootPlatformHome ofSystem(String platformOsFamily) {
        return new NBootPlatformHome(platformOsFamily, true, null, null);
    }

    public static NBootPlatformHome of(String platformOsFamily) {
        return new NBootPlatformHome(platformOsFamily, false, null, null);
    }

    public static NBootPlatformHome of(String platformOsFamily, boolean system) {
        return new NBootPlatformHome(platformOsFamily, system, null, null);
    }

    public static NBootPlatformHome ofPortable(String platformOsFamily, String userName) {
        return NBootPlatformHome.ofPortable(platformOsFamily, false, userName);
    }

    public static NBootPlatformHome ofPortableSystem(String platformOsFamily, String userName) {
        return NBootPlatformHome.ofPortable(platformOsFamily, true, userName);
    }

    public static NBootPlatformHome ofPortable(String platformOsFamily, boolean system, String userName) {
        NBootUtils.requireNonBlank(userName, "userName");
        return new NBootPlatformHome(platformOsFamily, system, p -> null, p -> NBootPlatformHome.portableProp(p, platformOsFamily, null, x -> {
            switch (x) {
                case "user.name": {
                    return userName;
                }
            }
            return null;
        }));
    }

    public static NBootPlatformHome ofPortable(String platformOsFamily, boolean system, Function<String, String> env, Function<String, String> props) {
        return new NBootPlatformHome(platformOsFamily, system, p -> null, p -> NBootPlatformHome.portableProp(p, platformOsFamily, env, props));
    }

    private static String portableProp(String p, String platformOsFamily, Function<String, String> env, Function<String, String> props) {
        String osFamily = NBootUtils.enumName(NBootUtils.firstNonBlank(platformOsFamily, "UNIX"));
        switch (p) {
            case "user.name": {
                String userName = NBootUtils.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name");
                return userName;
            }
            case "user.home": {
                String userName;
                String home;
                String string = home = props == null ? null : props.apply("user.home");
                if (!NBootUtils.isBlank(home)) {
                    return home;
                }
                switch (osFamily) {
                    case "WINDOWS": {
                        String userName2 = NBootUtils.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name");
                        return "C:\\Users\\" + userName2;
                    }
                }
                switch (userName = NBootUtils.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name")) {
                    case "root": {
                        return "/root";
                    }
                }
                return "/home/" + userName;
            }
            case "java.io.tmpdir": {
                String temp;
                String string = temp = props == null ? null : props.apply("java.io.tmpdir");
                if (!NBootUtils.isBlank(temp)) {
                    return temp;
                }
                switch (osFamily) {
                    case "WINDOWS": {
                        String userName = NBootUtils.requireNonBlank(props == null ? null : props.apply("user.name"), "user.name");
                        return "C:\\Users\\" + userName + "\\AppData\\Local\\Temp";
                    }
                }
                return "/tmp";
            }
        }
        return null;
    }

    public NBootPlatformHome(String platformOsFamily, boolean system, Function<String, String> env, Function<String, String> props) {
        this.platformOsFamily = platformOsFamily != null ? NBootUtils.enumName(platformOsFamily) : NBootPlatformHome.currentOsFamily();
        this.system = system;
        this.env = env != null ? env : System::getenv;
        this.props = props != null ? props : System::getProperty;
    }

    public String getCustomPlatformHomeFolder(String storeType, Map<NBootHomeLocation, String> homeLocations) {
        if (storeType == null) {
            return null;
        }
        String locationName = NBootUtils.enumId(storeType);
        String s = NBootUtils.trim(this.props.apply("nuts.home." + locationName + "." + NBootUtils.enumId(this.platformOsFamily)));
        if (!s.isEmpty()) {
            return s;
        }
        s = NBootUtils.trim(this.props.apply("nuts.export.home." + locationName + "." + NBootUtils.enumId(this.platformOsFamily)));
        if (!s.isEmpty()) {
            return s;
        }
        if (homeLocations != null && homeLocations.size() > 0) {
            NBootHomeLocation key = NBootHomeLocation.of(this.platformOsFamily, storeType);
            s = NBootUtils.trim(homeLocations.get(key));
            if (!s.isEmpty()) {
                return s;
            }
            key = NBootHomeLocation.of(null, storeType);
            s = NBootUtils.trim(homeLocations.get(key));
            if (!s.isEmpty()) {
                return s;
            }
        }
        return null;
    }

    public String getWorkspaceLocation(String location, Map<NBootHomeLocation, String> homeLocations, String workspaceName) {
        if (location == null) {
            return this.getWorkspaceLocation(workspaceName);
        }
        String s = this.getCustomPlatformHomeFolder(location, homeLocations);
        if (s != null) {
            return s;
        }
        return this.getWorkspaceStore(location, workspaceName);
    }

    public String getWorkspaceLocation(String workspaceName) {
        if (NBootUtils.isBlank(workspaceName)) {
            workspaceName = "default-workspace";
        } else if (workspaceName.equals(".") || workspaceName.equals("..") || workspaceName.indexOf(47) >= 0 || workspaceName.indexOf(92) >= 0) {
            return Paths.get(workspaceName, new String[0]).normalize().toAbsolutePath().toString();
        }
        return this.getHome() + this.getNativePath("/ws/" + workspaceName);
    }

    public String getHome() {
        if (this.system) {
            switch (NBootUtils.enumName(this.platformOsFamily)) {
                case "WINDOWS": {
                    return this.getWindowsProgramFiles() + "\\nuts";
                }
            }
            return "/etc/opt/nuts";
        }
        String userHome = this.props.apply("user.home");
        return userHome + this.getNativePath("/.nuts");
    }

    public String getWorkspaceStore(String storeType, String workspaceName) {
        Path fileName;
        if (storeType == null) {
            return this.getWorkspaceLocation(workspaceName);
        }
        workspaceName = NBootUtils.isBlank(workspaceName) ? "default-workspace" : ((fileName = Paths.get(workspaceName, new String[0]).normalize().toAbsolutePath().getFileName()) == null ? "default-workspace" : fileName.toString());
        return this.getStore(storeType) + this.getNativePath("/ws/" + this.getNativePath(workspaceName));
    }

    public static String currentOsFamily() {
        return NBootUtils.enumName(NBootUtils.firstNonBlank(NBootPlatformHome.parseOsFamily(System.getProperty("os.name")), "UNKNOWN"));
    }

    public static String parseOsFamily(String value) {
        String e;
        switch (e = NBootUtils.enumName(value)) {
            case "W": 
            case "WIN": 
            case "WINDOWS": {
                return "WINDOWS";
            }
            case "L": 
            case "LINUX": {
                return "LINUX";
            }
            case "M": 
            case "MAC": 
            case "MACOS": {
                return "macos";
            }
            case "U": 
            case "UNIX": {
                return "UNIX";
            }
            case "unknown": {
                return "UNKNOWN";
            }
        }
        if (e.startsWith("LINUX")) {
            return "LINUX";
        }
        if (e.startsWith("WIN")) {
            return "WINDOWS";
        }
        if (e.startsWith("MAC")) {
            return "MACOS";
        }
        if (e.startsWith("SUNOS") || e.startsWith("SUN_OS")) {
            return "UNIX";
        }
        if (e.startsWith("FREEBSD") || e.startsWith("FREE_BSD")) {
            return "UNIX";
        }
        switch (e) {
            case "DOS": 
            case "MSDOS": 
            case "MS_DOS": {
                return "WINDOWS";
            }
            case "NETWARE": 
            case "NET_WARE": {
                return "UNKNOWN";
            }
            case "OS2": 
            case "OS_2": {
                return "UNKNOWN";
            }
            case "TANDEM": {
                return "UNKNOWN";
            }
            case "Z_OS": 
            case "ZOS": {
                return "UNKNOWN";
            }
            case "OS400": 
            case "OS_400": {
                return "UNIX";
            }
            case "OPENVMS": 
            case "OPEN_VMS": {
                return "UNKNOWN";
            }
        }
        return null;
    }

    public String getStore(String storeType) {
        if (storeType == null) {
            return this.getHome();
        }
        String platformOsFamilyId = NBootUtils.enumId(this.platformOsFamily == null ? NBootPlatformHome.currentOsFamily() : this.platformOsFamily);
        String locationId = NBootUtils.enumId(storeType);
        if (this.system) {
            String s = null;
            s = NBootUtils.trim(this.props.apply("nuts.store.system." + locationId + "." + platformOsFamilyId));
            if (!s.isEmpty()) {
                return s;
            }
            s = NBootUtils.trim(this.props.apply("nuts.export.store.system." + locationId + "." + platformOsFamilyId));
            if (!s.isEmpty()) {
                return s.trim();
            }
            switch (locationId) {
                case "bin": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationId;
                        }
                    }
                    return "/opt/nuts/" + locationId;
                }
                case "lib": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationId;
                        }
                    }
                    return "/opt/nuts/" + locationId;
                }
                case "conf": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationId;
                        }
                    }
                    return "/etc/opt/nuts/" + locationId;
                }
                case "log": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationId;
                        }
                    }
                    return "/var/log/nuts";
                }
                case "cache": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationId;
                        }
                    }
                    return "/var/cache/nuts";
                }
                case "var": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return this.getWindowsProgramFiles() + "\\nuts\\" + locationId;
                        }
                    }
                    return "/var/opt/nuts";
                }
                case "temp": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            String pf = this.env.apply("TMP");
                            if (NBootUtils.isBlank(pf)) {
                                pf = this.getWindowsSystemRoot() + "\\Temp";
                            }
                            return pf + "\\nuts";
                        }
                    }
                    return "/tmp/nuts/system";
                }
                case "run": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            String pf = this.env.apply("TMP");
                            if (NBootUtils.isBlank(pf)) {
                                pf = this.getWindowsSystemRoot() + "\\Temp";
                            }
                            return pf + "\\nuts\\run";
                        }
                    }
                    return "/tmp/run/nuts/system";
                }
            }
        } else {
            String userHome = this.props.apply("user.home");
            String userName = this.props.apply("user.name");
            switch (locationId) {
                case "var": 
                case "bin": 
                case "lib": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return userHome + this.getNativePath("/AppData/Roaming/nuts/" + locationId);
                        }
                    }
                    String val = NBootUtils.trim(this.env.apply("XDG_DATA_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts/" + locationId;
                    }
                    return userHome + "/.local/share/nuts/" + locationId;
                }
                case "log": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return userHome + this.getNativePath("/AppData/LocalLow/nuts/" + locationId);
                        }
                    }
                    String val = NBootUtils.trim(this.env.apply("XDG_LOG_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.local/log/nuts";
                }
                case "run": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return userHome + this.getNativePath("/AppData/Local/nuts/" + locationId);
                        }
                    }
                    String val = NBootUtils.trim(this.env.apply("XDG_RUNTIME_DIR"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.local/run/nuts";
                }
                case "conf": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return userHome + this.getNativePath("/AppData/Roaming/nuts/" + locationId);
                        }
                    }
                    String val = NBootUtils.trim(this.env.apply("XDG_CONFIG_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.config/nuts";
                }
                case "cache": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return userHome + this.getNativePath("/AppData/Local/nuts/cache");
                        }
                    }
                    String val = NBootUtils.trim(this.env.apply("XDG_CACHE_HOME"));
                    if (!val.isEmpty()) {
                        return val + "/nuts";
                    }
                    return userHome + "/.cache/nuts";
                }
                case "temp": {
                    switch (platformOsFamilyId) {
                        case "windows": {
                            return userHome + this.getNativePath("/AppData/Local/nuts/" + locationId);
                        }
                    }
                    return this.props.apply("java.io.tmpdir") + this.getNativePath("/" + userName + "/nuts");
                }
            }
        }
        throw new NBootException(NBootMsg.ofC("unsupported getDefaultPlatformHomeFolderBase %s/%s", platformOsFamilyId, storeType));
    }

    public String getWindowsProgramFiles() {
        String s = this.env.apply("ProgramFiles");
        if (!NBootUtils.isBlank(s)) {
            return s;
        }
        String c = this.getWindowsSystemDrive();
        if (!NBootUtils.isBlank(c)) {
            return c + "\\Program Files";
        }
        return "C:\\Program Files";
    }

    public String getWindowsProgramFilesX86() {
        String s = this.env.apply("ProgramFiles(x86)");
        if (!NBootUtils.isBlank(s)) {
            return s;
        }
        String c = this.getWindowsSystemDrive();
        if (!NBootUtils.isBlank(c)) {
            return c + "\\Program Files (x86)";
        }
        return "C:\\Program Files (x86)";
    }

    public String getWindowsSystemRoot() {
        String e = this.env.apply("SystemRoot");
        if (!NBootUtils.isBlank(e)) {
            return e;
        }
        e = this.env.apply("windir");
        if (!NBootUtils.isBlank(e)) {
            return e;
        }
        e = this.env.apply("SystemDrive");
        if (!NBootUtils.isBlank(e)) {
            return e + "\\Windows";
        }
        return "C:\\Windows";
    }

    public String getWindowsSystemDrive() {
        String e = this.env.apply("SystemDrive");
        if (!NBootUtils.isBlank(e)) {
            return e;
        }
        e = this.env.apply("SystemRoot");
        if (!NBootUtils.isBlank(e)) {
            return e.substring(0, 2);
        }
        e = this.env.apply("windir");
        if (!NBootUtils.isBlank(e)) {
            return e.substring(0, 2);
        }
        return null;
    }

    private String getNativePath(String s) {
        switch (NBootUtils.enumName(this.platformOsFamily)) {
            case "WINDOWS": {
                return s.replace('/', '\\');
            }
        }
        return s.replace('\\', '/');
    }

    public static String[] osFamilies() {
        return new String[]{"WINDOWS", "LINUX", "MACOS", "UNIX", "UNKNOWN"};
    }

    public static String[] storeTypes() {
        return new String[]{"BIN", "CONF", "VAR", "LOG", "TEMP", "CACHE", "LIB", "RUN"};
    }

    public Map<String, String> buildLocations(String storeStrategy, Map<String, String> baseLocations, Map<NBootHomeLocation, String> homeLocations, String workspaceLocation) {
        workspaceLocation = this.getWorkspaceLocation(workspaceLocation);
        String[] storeTypes = NBootPlatformHome.storeTypes();
        String[] homes = new String[storeTypes.length];
        for (int i = 0; i < storeTypes.length; ++i) {
            String location = storeTypes[i];
            String string = this.getWorkspaceLocation(location, homeLocations, workspaceLocation);
            if (NBootUtils.isBlank(string)) {
                throw new NBootException(NBootMsg.ofC("missing Home for %s", location));
            }
            homes[i] = string;
        }
        if (storeStrategy == null) {
            storeStrategy = "EXPLODED";
        }
        LinkedHashMap<String, String> storeLocations = new LinkedHashMap<String, String>();
        if (baseLocations != null) {
            for (Map.Entry entry : baseLocations.entrySet()) {
                String loc = (String)entry.getKey();
                if (loc == null) {
                    throw new NBootException(NBootMsg.ofPlain("null location"));
                }
                storeLocations.put(NBootUtils.enumId(loc), (String)entry.getValue());
            }
        }
        for (int i = 0; i < storeTypes.length; ++i) {
            String c;
            String string = storeTypes[i];
            String locationId = NBootUtils.enumId(string);
            String _storeLocation = (String)storeLocations.get(locationId);
            if (NBootUtils.isBlank(_storeLocation)) {
                switch (NBootUtils.enumName(storeStrategy)) {
                    case "STANDALONE": {
                        c = this.getCustomPlatformHomeFolder(string, homeLocations);
                        storeLocations.put(locationId, c == null ? workspaceLocation + File.separator + locationId : c);
                        break;
                    }
                    case "EXPLODED": {
                        storeLocations.put(locationId, homes[i]);
                    }
                }
                continue;
            }
            if (!Paths.get(_storeLocation, new String[0]).isAbsolute()) {
                switch (NBootUtils.enumName(storeStrategy)) {
                    case "STANDALONE": {
                        c = this.getCustomPlatformHomeFolder(string, homeLocations);
                        storeLocations.put(locationId, c == null ? workspaceLocation + File.separator + locationId + NBootUtils.getNativePath("/" + _storeLocation) : c + NBootUtils.getNativePath("/" + _storeLocation));
                        break;
                    }
                    case "EXPLODED": {
                        storeLocations.put(locationId, homes[i] + NBootUtils.getNativePath("/" + _storeLocation));
                    }
                }
                continue;
            }
            storeLocations.put(locationId, _storeLocation);
        }
        return storeLocations;
    }
}

